/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.settlement.functions;

import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustableOrAdjustedOrRelativeDate;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.asset.ValuationMethod;
import cdm.observable.asset.ValuationSource;
import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.FxCashSettlement;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapFxCashSettlementToSettlementTermsDefault.class)
public abstract class MapFxCashSettlementToSettlementTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustableOrAdjustedOrRelativeDate mapAdjustableOrAdjustedOrRelativeDate;
    @Inject
    protected MapCurrency mapCurrency;

    public SettlementTerms evaluate(FxCashSettlement fpmlFxCashSettlement, Date valueDate) {
        SettlementTerms settlementTerms;
        SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = this.doEvaluate(fpmlFxCashSettlement, valueDate);
        if (settlementTermsBuilder == null) {
            settlementTerms = null;
        } else {
            settlementTerms = settlementTermsBuilder.build();
            this.objectValidator.validate(SettlementTerms.class, (RosettaModelObject)settlementTerms);
        }
        return settlementTerms;
    }

    protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(FxCashSettlement var1, Date var2);

    public static class MapFxCashSettlementToSettlementTermsDefault
    extends MapFxCashSettlementToSettlementTerms {
        @Override
        protected SettlementTerms.SettlementTermsBuilder doEvaluate(FxCashSettlement fpmlFxCashSettlement, Date valueDate) {
            SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
            return this.assignOutput(settlementTerms, fpmlFxCashSettlement, valueDate);
        }

        protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, FxCashSettlement fpmlFxCashSettlement, Date valueDate) {
            CashSettlementTerms cashSettlementTerms = CashSettlementTerms.builder().setCashSettlementMethod(null).setValuationMethod(ValuationMethod.builder().setValuationSource(ValuationSource.builder().setQuotedCurrencyPairValue(null).setInformationSource(FxSpotRateSource.builder().setPrimarySource(null).build()).setReferenceBanks(null).build()).setQuotationMethod(null).setCashCollateralValuationMethod(null).build()).build();
            settlementTerms = (SettlementTerms.SettlementTermsBuilder)this.toBuilder(SettlementTerms.builder().setSettlementType(SettlementTypeEnum.CASH).setSettlementCurrency(this.mapCurrency.evaluate((Currency)MapperS.of((Object)fpmlFxCashSettlement).map("getSettlementCurrency", fxCashSettlement -> fxCashSettlement.getSettlementCurrency()).get())).setSettlementDate(SettlementDate.builder().setAdjustableOrRelativeDate(this.mapAdjustableOrAdjustedOrRelativeDate.evaluate(null, (AdjustableDate)MapperS.of((Object)fpmlFxCashSettlement).map("getSettlementDate", fxCashSettlement -> fxCashSettlement.getSettlementDate()).get(), null)).setValueDate(valueDate).build()).setCashSettlementTerms(cashSettlementTerms == null ? Collections.emptyList() : Collections.singletonList(cashSettlementTerms)).build());
            return Optional.ofNullable(settlementTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

