/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.party.LegalEntity;
import cdm.ingest.fpml.confirmation.party.functions.MapExchangeIdToLegalEntity;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapAssetIdentifierList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.IdentifiedAsset;
import fpml.consolidated.shared.ExchangeId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapIdentifiedAssetToSecurityDefault.class)
public abstract class MapIdentifiedAssetToSecurity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAssetIdentifierList mapAssetIdentifierList;
    @Inject
    protected MapExchangeIdToLegalEntity mapExchangeIdToLegalEntity;

    public Security evaluate(IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
        Security security;
        Security.SecurityBuilder securityBuilder = this.doEvaluate(fpmlIdentifiedAsset, fpmlExchangeId, fpmlRelatedExchangeId, instrumentType);
        if (securityBuilder == null) {
            security = null;
        } else {
            security = securityBuilder.build();
            this.objectValidator.validate(Security.class, (RosettaModelObject)security);
        }
        return security;
    }

    protected abstract Security.SecurityBuilder doEvaluate(IdentifiedAsset var1, ExchangeId var2, List<? extends ExchangeId> var3, InstrumentTypeEnum var4);

    public static class MapIdentifiedAssetToSecurityDefault
    extends MapIdentifiedAssetToSecurity {
        @Override
        protected Security.SecurityBuilder doEvaluate(IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
            if (fpmlRelatedExchangeId == null) {
                fpmlRelatedExchangeId = Collections.emptyList();
            }
            Security.SecurityBuilder security = Security.builder();
            return this.assignOutput(security, fpmlIdentifiedAsset, fpmlExchangeId, fpmlRelatedExchangeId, instrumentType);
        }

        protected Security.SecurityBuilder assignOutput(Security.SecurityBuilder security, IdentifiedAsset fpmlIdentifiedAsset, ExchangeId fpmlExchangeId, List<? extends ExchangeId> fpmlRelatedExchangeId, InstrumentTypeEnum instrumentType) {
            Boolean ifThenElseResult = null;
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlExchangeId)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = true;
            }
            security = (Security.SecurityBuilder)this.toBuilder(Security.builder().setIdentifier(new ArrayList<AssetIdentifier>(this.mapAssetIdentifierList.evaluate(fpmlIdentifiedAsset))).setIsExchangeListed(ifThenElseResult).setExchange((LegalEntity)MapperS.of((Object)fpmlExchangeId).mapSingleToItem(item -> MapperS.of((Object)this.mapExchangeIdToLegalEntity.evaluate((ExchangeId)item.get()))).get()).setRelatedExchange(MapperC.of(fpmlRelatedExchangeId).mapItem(item -> MapperS.of((Object)this.mapExchangeIdToLegalEntity.evaluate((ExchangeId)item.get()))).getMulti()).setInstrumentType(instrumentType).build());
            return Optional.ofNullable(security).map(o -> o.prune()).orElse(null);
        }
    }
}

