/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.event.common.TransferState;
import cdm.ingest.fpml.confirmation.payment.functions.MapPaymentToTransferState;
import cdm.observable.asset.FeeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Payment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapPaymentListToTransferStateListDefault.class)
public abstract class MapPaymentListToTransferStateList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapPaymentToTransferState mapPaymentToTransferState;

    public List<? extends TransferState> evaluate(List<? extends Payment> fpmlPaymentList, FeeTypeEnum cdmFeeType) {
        List transferStateList;
        List<TransferState.TransferStateBuilder> transferStateListBuilder = this.doEvaluate(fpmlPaymentList, cdmFeeType);
        if (transferStateListBuilder == null) {
            transferStateList = null;
        } else {
            transferStateList = transferStateListBuilder.stream().map(TransferState::build).collect(Collectors.toList());
            this.objectValidator.validate(TransferState.class, transferStateList);
        }
        return transferStateList;
    }

    protected abstract List<TransferState.TransferStateBuilder> doEvaluate(List<? extends Payment> var1, FeeTypeEnum var2);

    public static class MapPaymentListToTransferStateListDefault
    extends MapPaymentListToTransferStateList {
        @Override
        protected List<TransferState.TransferStateBuilder> doEvaluate(List<? extends Payment> fpmlPaymentList, FeeTypeEnum cdmFeeType) {
            if (fpmlPaymentList == null) {
                fpmlPaymentList = Collections.emptyList();
            }
            ArrayList<TransferState.TransferStateBuilder> transferStateList = new ArrayList<TransferState.TransferStateBuilder>();
            return this.assignOutput(transferStateList, fpmlPaymentList, cdmFeeType);
        }

        protected List<TransferState.TransferStateBuilder> assignOutput(List<TransferState.TransferStateBuilder> transferStateList, List<? extends Payment> fpmlPaymentList, FeeTypeEnum cdmFeeType) {
            transferStateList.addAll(this.toBuilder(MapperC.of(fpmlPaymentList).mapItem(item -> MapperS.of((Object)this.mapPaymentToTransferState.evaluate((Payment)item.get(), cdmFeeType))).getMulti()));
            return Optional.ofNullable(transferStateList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

