/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.party.functions;

import cdm.base.staticdata.party.Party;
import cdm.ingest.fpml.confirmation.common.functions.MapStringWithScheme;
import cdm.ingest.fpml.confirmation.party.functions.MapBusinessUnit;
import cdm.ingest.fpml.confirmation.party.functions.MapContactInformation;
import cdm.ingest.fpml.confirmation.party.functions.MapNaturalPerson;
import cdm.ingest.fpml.confirmation.party.functions.MapPartyIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.BusinessUnit;
import fpml.consolidated.shared.ContactInformation;
import fpml.consolidated.shared.PartyId;
import fpml.consolidated.shared.PartyModel;
import fpml.consolidated.shared.PartyName;
import fpml.consolidated.shared.Person;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPartyDefault.class)
public abstract class MapParty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapBusinessUnit mapBusinessUnit;
    @Inject
    protected MapContactInformation mapContactInformation;
    @Inject
    protected MapNaturalPerson mapNaturalPerson;
    @Inject
    protected MapPartyIdentifier mapPartyIdentifier;
    @Inject
    protected MapStringWithScheme mapStringWithScheme;

    public Party evaluate(fpml.consolidated.shared.Party fpmlParty) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(fpmlParty);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(fpml.consolidated.shared.Party var1);

    protected abstract MapperS<? extends PartyModel> partyModel(fpml.consolidated.shared.Party var1);

    protected abstract MapperS<? extends PartyName> partyName(fpml.consolidated.shared.Party var1);

    public static class MapPartyDefault
    extends MapParty {
        @Override
        protected Party.PartyBuilder doEvaluate(fpml.consolidated.shared.Party fpmlParty) {
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, fpmlParty);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, fpml.consolidated.shared.Party fpmlParty) {
            Party.PartyBuilder withMetaArgument = Party.builder().setPartyId(this.partyModel(fpmlParty).mapC("getPartyId", _partyModel -> _partyModel.getPartyId()).mapItem(item -> MapperS.of((Object)this.mapPartyIdentifier.evaluate((PartyId)item.get()))).getMulti()).setName(this.mapStringWithScheme.evaluate((String)this.partyName(fpmlParty).map("getValue", _partyName -> _partyName.getValue()).get(), (String)this.partyName(fpmlParty).map("getPartyNameScheme", _partyName -> _partyName.getPartyNameScheme()).get())).setBusinessUnit(this.partyModel(fpmlParty).mapC("getBusinessUnit", _partyModel -> _partyModel.getBusinessUnit()).mapItem(item -> MapperS.of((Object)this.mapBusinessUnit.evaluate((BusinessUnit)item.get()))).getMulti()).setPerson(this.partyModel(fpmlParty).mapC("getPerson", _partyModel -> _partyModel.getPerson()).mapItem(item -> MapperS.of((Object)this.mapNaturalPerson.evaluate((Person)item.get()))).getMulti()).setPersonRole(Collections.emptyList()).setAccount(null).setContactInformation(this.mapContactInformation.evaluate((ContactInformation)this.partyModel(fpmlParty).map("getContactInfo", _partyModel -> _partyModel.getContactInfo()).get())).build() == null ? null : Party.builder().setPartyId(this.partyModel(fpmlParty).mapC("getPartyId", _partyModel -> _partyModel.getPartyId()).mapItem(item -> MapperS.of((Object)this.mapPartyIdentifier.evaluate((PartyId)item.get()))).getMulti()).setName(this.mapStringWithScheme.evaluate((String)this.partyName(fpmlParty).map("getValue", _partyName -> _partyName.getValue()).get(), (String)this.partyName(fpmlParty).map("getPartyNameScheme", _partyName -> _partyName.getPartyNameScheme()).get())).setBusinessUnit(this.partyModel(fpmlParty).mapC("getBusinessUnit", _partyModel -> _partyModel.getBusinessUnit()).mapItem(item -> MapperS.of((Object)this.mapBusinessUnit.evaluate((BusinessUnit)item.get()))).getMulti()).setPerson(this.partyModel(fpmlParty).mapC("getPerson", _partyModel -> _partyModel.getPerson()).mapItem(item -> MapperS.of((Object)this.mapNaturalPerson.evaluate((Person)item.get()))).getMulti()).setPersonRole(Collections.emptyList()).setAccount(null).setContactInformation(this.mapContactInformation.evaluate((ContactInformation)this.partyModel(fpmlParty).map("getContactInfo", _partyModel -> _partyModel.getContactInfo()).get())).build().toBuilder();
            withMetaArgument.getOrCreateMeta().setExternalKey((String)MapperS.of((Object)fpmlParty).map("getId", _party -> _party.getId()).get());
            party = (Party.PartyBuilder)this.toBuilder(withMetaArgument);
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PartyModel> partyModel(fpml.consolidated.shared.Party fpmlParty) {
            return MapperS.of((Object)fpmlParty).map("getPartyModel", party -> party.getPartyModel());
        }

        @Override
        protected MapperS<? extends PartyName> partyName(fpml.consolidated.shared.Party fpmlParty) {
            return this.partyModel(fpmlParty).map("getPartyName", _partyModel -> _partyModel.getPartyName());
        }
    }
}

