/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.datetime.functions;

import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustedRelativeDateReference;
import cdm.product.asset.DividendPaymentDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.shared.DateReference;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapDateReferenceToDividendPaymentDateDefault.class)
public abstract class MapDateReferenceToDividendPaymentDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustedRelativeDateReference mapAdjustedRelativeDateReference;

    public DividendPaymentDate evaluate(DateReference fpmlDateReference) {
        DividendPaymentDate dividendPaymentDate;
        DividendPaymentDate.DividendPaymentDateBuilder dividendPaymentDateBuilder = this.doEvaluate(fpmlDateReference);
        if (dividendPaymentDateBuilder == null) {
            dividendPaymentDate = null;
        } else {
            dividendPaymentDate = dividendPaymentDateBuilder.build();
            this.objectValidator.validate(DividendPaymentDate.class, (RosettaModelObject)dividendPaymentDate);
        }
        return dividendPaymentDate;
    }

    protected abstract DividendPaymentDate.DividendPaymentDateBuilder doEvaluate(DateReference var1);

    public static class MapDateReferenceToDividendPaymentDateDefault
    extends MapDateReferenceToDividendPaymentDate {
        @Override
        protected DividendPaymentDate.DividendPaymentDateBuilder doEvaluate(DateReference fpmlDateReference) {
            DividendPaymentDate.DividendPaymentDateBuilder dividendPaymentDate = DividendPaymentDate.builder();
            return this.assignOutput(dividendPaymentDate, fpmlDateReference);
        }

        protected DividendPaymentDate.DividendPaymentDateBuilder assignOutput(DividendPaymentDate.DividendPaymentDateBuilder dividendPaymentDate, DateReference fpmlDateReference) {
            dividendPaymentDate = (DividendPaymentDate.DividendPaymentDateBuilder)this.toBuilder(DividendPaymentDate.builder().setDividendDate(this.mapAdjustedRelativeDateReference.evaluate(fpmlDateReference)).build());
            return Optional.ofNullable(dividendPaymentDate).map(o -> o.prune()).orElse(null);
        }
    }
}

