/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.staticdata.asset.common.Asset;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.meta.PositionBaseMeta;
import cdm.observable.asset.Money;
import cdm.observable.asset.PriceQuantity;
import cdm.product.template.Product;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PositionBase", builder=PositionBaseBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="PositionBase", model="cdm", builder=PositionBaseBuilderImpl.class, version="7.0.0-dev.52")
public interface PositionBase
extends RosettaModelObject {
    public static final PositionBaseMeta metaData = new PositionBaseMeta();

    public List<? extends PriceQuantity> getPriceQuantity();

    public Product getProduct();

    public Asset getAsset();

    public Money getCashBalance();

    public ReferenceWithMetaTradeState getTradeReference();

    public PositionBase build();

    public PositionBaseBuilder toBuilder();

    public static PositionBaseBuilder builder() {
        return new PositionBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends PositionBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PositionBase> getType() {
        return PositionBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asset"), processor, Asset.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashBalance"), processor, Money.class, this.getCashBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.class, this.getTradeReference(), new AttributeMeta[0]);
    }

    public static class PositionBaseBuilderImpl
    implements PositionBaseBuilder {
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected Product.ProductBuilder product;
        protected Asset.AssetBuilder asset;
        protected Money.MoneyBuilder cashBalance;
        protected ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder tradeReference;

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public Asset.AssetBuilder getAsset() {
            return this.asset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateAsset() {
            Asset.AssetBuilder result = this.asset != null ? this.asset : (this.asset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public Money.MoneyBuilder getCashBalance() {
            return this.cashBalance;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCashBalance() {
            Money.MoneyBuilder result = this.cashBalance != null ? this.cashBalance : (this.cashBalance = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference() {
            ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder result = this.tradeReference != null ? this.tradeReference : (this.tradeReference = ReferenceWithMetaTradeState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public PositionBaseBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public PositionBaseBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public PositionBaseBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public PositionBaseBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public PositionBaseBuilder setProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public PositionBaseBuilder setAsset(Asset _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public PositionBaseBuilder setCashBalance(Money _cashBalance) {
            this.cashBalance = _cashBalance == null ? null : _cashBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public PositionBaseBuilder setTradeReference(ReferenceWithMetaTradeState _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        public PositionBaseBuilder setTradeReferenceValue(TradeState _tradeReference) {
            this.getOrCreateTradeReference().setValue(_tradeReference);
            return this;
        }

        @Override
        public PositionBase build() {
            return new PositionBaseImpl(this);
        }

        @Override
        public PositionBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public PositionBaseBuilder prune() {
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            if (this.asset != null && !this.asset.prune().hasData()) {
                this.asset = null;
            }
            if (this.cashBalance != null && !this.cashBalance.prune().hasData()) {
                this.cashBalance = null;
            }
            if (this.tradeReference != null && !this.tradeReference.prune().hasData()) {
                this.tradeReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getAsset() != null && this.getAsset().hasData()) {
                return true;
            }
            if (this.getCashBalance() != null && this.getCashBalance().hasData()) {
                return true;
            }
            return this.getTradeReference() != null && this.getTradeReference().hasData();
        }

        public PositionBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PositionBaseBuilder o = (PositionBaseBuilder)other;
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsset(), (RosettaModelObjectBuilder)o.getAsset(), this::setAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashBalance(), (RosettaModelObjectBuilder)o.getCashBalance(), this::setCashBalance);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeReference(), (RosettaModelObjectBuilder)o.getTradeReference(), this::setTradeReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PositionBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            if (!Objects.equals(this.cashBalance, _that.getCashBalance())) {
                return false;
            }
            return Objects.equals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.cashBalance != null ? this.cashBalance.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PositionBaseBuilder {priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", asset=" + this.asset + ", cashBalance=" + this.cashBalance + ", tradeReference=" + this.tradeReference + '}';
        }
    }

    public static interface PositionBaseBuilder
    extends PositionBase,
    RosettaModelObjectBuilder {
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public Asset.AssetBuilder getOrCreateAsset();

        @Override
        public Asset.AssetBuilder getAsset();

        public Money.MoneyBuilder getOrCreateCashBalance();

        @Override
        public Money.MoneyBuilder getCashBalance();

        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference();

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeReference();

        public PositionBaseBuilder addPriceQuantity(PriceQuantity var1);

        public PositionBaseBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public PositionBaseBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public PositionBaseBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        public PositionBaseBuilder setProduct(Product var1);

        public PositionBaseBuilder setAsset(Asset var1);

        public PositionBaseBuilder setCashBalance(Money var1);

        public PositionBaseBuilder setTradeReference(ReferenceWithMetaTradeState var1);

        public PositionBaseBuilder setTradeReferenceValue(TradeState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asset"), processor, Asset.AssetBuilder.class, this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashBalance"), processor, Money.MoneyBuilder.class, this.getCashBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
        }

        public PositionBaseBuilder prune();
    }

    public static class PositionBaseImpl
    implements PositionBase {
        private final List<? extends PriceQuantity> priceQuantity;
        private final Product product;
        private final Asset asset;
        private final Money cashBalance;
        private final ReferenceWithMetaTradeState tradeReference;

        protected PositionBaseImpl(PositionBaseBuilder builder) {
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.asset = Optional.ofNullable(builder.getAsset()).map(f -> f.build()).orElse(null);
            this.cashBalance = Optional.ofNullable(builder.getCashBalance()).map(f -> f.build()).orElse(null);
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public Product getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public Asset getAsset() {
            return this.asset;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public Money getCashBalance() {
            return this.cashBalance;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public ReferenceWithMetaTradeState getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public PositionBase build() {
            return this;
        }

        @Override
        public PositionBaseBuilder toBuilder() {
            PositionBaseBuilder builder = PositionBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PositionBaseBuilder builder) {
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getAsset()).ifPresent(builder::setAsset);
            Optional.ofNullable(this.getCashBalance()).ifPresent(builder::setCashBalance);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PositionBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            if (!Objects.equals(this.cashBalance, _that.getCashBalance())) {
                return false;
            }
            return Objects.equals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.cashBalance != null ? this.cashBalance.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PositionBase {priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", asset=" + this.asset + ", cashBalance=" + this.cashBalance + ", tradeReference=" + this.tradeReference + '}';
        }
    }
}

