/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.functions.ResolveAdjustableDate;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.util.AssetDeepPathUtil;
import cdm.event.common.functions.AdjustedValuationDates;
import cdm.event.common.functions.ResolvePerformanceValuationTime;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.PerformanceValuationDates;
import cdm.observable.asset.ValuationDates;
import cdm.observable.asset.metafields.ReferenceWithMetaObservable;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.observable.common.TimeTypeEnum;
import cdm.observable.event.ObservationIdentifier;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolvePerformanceObservationIdentifiersDefault.class)
public abstract class ResolvePerformanceObservationIdentifiers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustedValuationDates adjustedValuationDates;
    @Inject
    protected AssetDeepPathUtil assetDeepPathUtil;
    @Inject
    protected ResolveAdjustableDate resolveAdjustableDate;
    @Inject
    protected ResolvePerformanceValuationTime resolvePerformanceValuationTime;

    public ObservationIdentifier evaluate(PerformancePayout payout, Date adjustedDate) {
        ObservationIdentifier identifiers;
        ObservationIdentifier.ObservationIdentifierBuilder identifiersBuilder = this.doEvaluate(payout, adjustedDate);
        if (identifiersBuilder == null) {
            identifiers = null;
        } else {
            identifiers = identifiersBuilder.build();
            this.objectValidator.validate(ObservationIdentifier.class, (RosettaModelObject)identifiers);
        }
        return identifiers;
    }

    protected abstract ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(PerformancePayout var1, Date var2);

    protected abstract MapperS<Date> adjustedFinalValuationDate(PerformancePayout var1, Date var2);

    protected abstract MapperS<? extends PerformanceValuationDates> valuationDates(PerformancePayout var1, Date var2);

    public static class ResolvePerformanceObservationIdentifiersDefault
    extends ResolvePerformanceObservationIdentifiers {
        @Override
        protected ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(PerformancePayout payout, Date adjustedDate) {
            ObservationIdentifier.ObservationIdentifierBuilder identifiers = ObservationIdentifier.builder();
            return this.assignOutput(identifiers, payout, adjustedDate);
        }

        protected ObservationIdentifier.ObservationIdentifierBuilder assignOutput(ObservationIdentifier.ObservationIdentifierBuilder identifiers, PerformancePayout payout, Date adjustedDate) {
            ReferenceWithMetaObservable referenceWithMetaObservable = (ReferenceWithMetaObservable)MapperS.of((Object)payout).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getObservable", underlier -> underlier.getObservable()).get();
            identifiers.setObservable(referenceWithMetaObservable == null ? null : referenceWithMetaObservable.getValue());
            MapperC thenArg = MapperC.of(this.adjustedValuationDates.evaluate((ValuationDates)MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).get())).filterItemNullSafe(item -> ExpressionOperators.lessThanEquals((Mapper)item, (Mapper)MapperS.of((Object)adjustedDate), (CardinalityOperator)CardinalityOperator.All).get());
            identifiers.setObservationDate((Date)thenArg.last().get());
            identifiers.setObservationTime(this.resolvePerformanceValuationTime.evaluate((BusinessCenterTime)this.valuationDates(payout, adjustedDate).map("getValuationTime", performanceValuationDates -> performanceValuationDates.getValuationTime()).get(), (TimeTypeEnum)((Object)this.valuationDates(payout, adjustedDate).map("getValuationTimeType", performanceValuationDates -> performanceValuationDates.getValuationTimeType()).get()), (AssetIdentifier)MapperS.of((Object)identifiers).map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).map("getAsset", observable -> observable.getAsset()).mapC("chooseIdentifier", asset -> this.assetDeepPathUtil.chooseIdentifier((Asset)asset)).get(), (DeterminationMethodEnum)((Object)this.valuationDates(payout, adjustedDate).map("getDeterminationMethod", performanceValuationDates -> performanceValuationDates.getDeterminationMethod()).get())));
            identifiers.setInformationSource((InformationSource)MapperS.of((Object)payout).map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).map("getInformationSource", observationTerms -> observationTerms.getInformationSource()).map("getPrimarySource", fxSpotRateSource -> fxSpotRateSource.getPrimarySource()).get());
            identifiers.getOrCreateDeterminationMethodology().setDeterminationMethod((DeterminationMethodEnum)((Object)this.valuationDates(payout, adjustedDate).map("getDeterminationMethod", performanceValuationDates -> performanceValuationDates.getDeterminationMethod()).get()));
            return Optional.ofNullable(identifiers).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<Date> adjustedFinalValuationDate(PerformancePayout payout, Date adjustedDate) {
            return MapperS.of((Object)this.resolveAdjustableDate.evaluate((AdjustableOrRelativeDate)MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getFinalValuationDate", _valuationDates -> _valuationDates.getFinalValuationDate()).map("getValuationDate", performanceValuationDates -> performanceValuationDates.getValuationDate()).get()));
        }

        @Override
        protected MapperS<? extends PerformanceValuationDates> valuationDates(PerformancePayout payout, Date adjustedDate) {
            if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)adjustedDate), this.adjustedFinalValuationDate(payout, adjustedDate), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getInterimValuationDate", _valuationDates -> _valuationDates.getInterimValuationDate());
            }
            return MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getFinalValuationDate", _valuationDates -> _valuationDates.getFinalValuationDate());
        }
    }
}

