/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.meta.AncillaryPartyMeta;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AncillaryParty", builder=AncillaryPartyBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="AncillaryParty", model="cdm", builder=AncillaryPartyBuilderImpl.class, version="7.0.0-dev.52")
public interface AncillaryParty
extends RosettaModelObject {
    public static final AncillaryPartyMeta metaData = new AncillaryPartyMeta();

    public AncillaryRoleEnum getRole();

    public List<? extends ReferenceWithMetaParty> getPartyReference();

    public CounterpartyRoleEnum getOnBehalfOf();

    public AncillaryParty build();

    public AncillaryPartyBuilder toBuilder();

    public static AncillaryPartyBuilder builder() {
        return new AncillaryPartyBuilderImpl();
    }

    default public RosettaMetaData<? extends AncillaryParty> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AncillaryParty> getType() {
        return AncillaryParty.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("role"), AncillaryRoleEnum.class, (Object)this.getRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("onBehalfOf"), CounterpartyRoleEnum.class, (Object)this.getOnBehalfOf(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AncillaryPartyBuilderImpl
    implements AncillaryPartyBuilder {
        protected AncillaryRoleEnum role;
        protected List<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> partyReference = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
        protected CounterpartyRoleEnum onBehalfOf;

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AncillaryRoleEnum getRole() {
            return this.role;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference(int index) {
            if (this.partyReference == null) {
                this.partyReference = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
            }
            return (ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder)this.getIndex(this.partyReference, index, () -> {
                ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder newPartyReference = ReferenceWithMetaParty.builder();
                return newPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public CounterpartyRoleEnum getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AncillaryPartyBuilder setRole(AncillaryRoleEnum _role) {
            this.role = _role == null ? null : _role;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public AncillaryPartyBuilder addPartyReference(ReferenceWithMetaParty _partyReference) {
            if (_partyReference != null) {
                this.partyReference.add(_partyReference.toBuilder());
            }
            return this;
        }

        @Override
        public AncillaryPartyBuilder addPartyReference(ReferenceWithMetaParty _partyReference, int idx) {
            this.getIndex(this.partyReference, idx, () -> _partyReference.toBuilder());
            return this;
        }

        @Override
        public AncillaryPartyBuilder addPartyReferenceValue(Party _partyReference) {
            this.getOrCreatePartyReference(-1).setValue(_partyReference.toBuilder());
            return this;
        }

        @Override
        public AncillaryPartyBuilder addPartyReferenceValue(Party _partyReference, int idx) {
            this.getOrCreatePartyReference(idx).setValue(_partyReference.toBuilder());
            return this;
        }

        @Override
        public AncillaryPartyBuilder addPartyReference(List<? extends ReferenceWithMetaParty> partyReferences) {
            if (partyReferences != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : partyReferences) {
                    this.partyReference.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyReference")
        public AncillaryPartyBuilder setPartyReference(List<? extends ReferenceWithMetaParty> partyReferences) {
            this.partyReference = partyReferences == null ? new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>() : (List)partyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AncillaryPartyBuilder addPartyReferenceValue(List<? extends Party> partyReferences) {
            if (partyReferences != null) {
                for (Party party : partyReferences) {
                    this.addPartyReferenceValue(party);
                }
            }
            return this;
        }

        @Override
        public AncillaryPartyBuilder setPartyReferenceValue(List<? extends Party> partyReferences) {
            this.partyReference.clear();
            if (partyReferences != null) {
                partyReferences.forEach(this::addPartyReferenceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public AncillaryPartyBuilder setOnBehalfOf(CounterpartyRoleEnum _onBehalfOf) {
            this.onBehalfOf = _onBehalfOf == null ? null : _onBehalfOf;
            return this;
        }

        @Override
        public AncillaryParty build() {
            return new AncillaryPartyImpl(this);
        }

        @Override
        public AncillaryPartyBuilder toBuilder() {
            return this;
        }

        @Override
        public AncillaryPartyBuilder prune() {
            this.partyReference = this.partyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getRole() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getOnBehalfOf() != null;
        }

        public AncillaryPartyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AncillaryPartyBuilder o = (AncillaryPartyBuilder)other;
            merger.mergeRosetta(this.getPartyReference(), o.getPartyReference(), this::getOrCreatePartyReference);
            merger.mergeBasic((Object)this.getRole(), (Object)o.getRole(), this::setRole, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOnBehalfOf(), (Object)o.getOnBehalfOf(), this::setOnBehalfOf, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AncillaryParty _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.role, (Object)_that.getRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return Objects.equals((Object)this.onBehalfOf, (Object)_that.getOnBehalfOf());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.role != null ? ((Object)((Object)this.role)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? ((Object)((Object)this.onBehalfOf)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AncillaryPartyBuilder {role=" + (Object)((Object)this.role) + ", partyReference=" + this.partyReference + ", onBehalfOf=" + (Object)((Object)this.onBehalfOf) + '}';
        }
    }

    public static interface AncillaryPartyBuilder
    extends AncillaryParty,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference(int var1);

        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getPartyReference();

        public AncillaryPartyBuilder setRole(AncillaryRoleEnum var1);

        public AncillaryPartyBuilder addPartyReference(ReferenceWithMetaParty var1);

        public AncillaryPartyBuilder addPartyReference(ReferenceWithMetaParty var1, int var2);

        public AncillaryPartyBuilder addPartyReferenceValue(Party var1);

        public AncillaryPartyBuilder addPartyReferenceValue(Party var1, int var2);

        public AncillaryPartyBuilder addPartyReference(List<? extends ReferenceWithMetaParty> var1);

        public AncillaryPartyBuilder setPartyReference(List<? extends ReferenceWithMetaParty> var1);

        public AncillaryPartyBuilder addPartyReferenceValue(List<? extends Party> var1);

        public AncillaryPartyBuilder setPartyReferenceValue(List<? extends Party> var1);

        public AncillaryPartyBuilder setOnBehalfOf(CounterpartyRoleEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("role"), AncillaryRoleEnum.class, (Object)this.getRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("onBehalfOf"), CounterpartyRoleEnum.class, (Object)this.getOnBehalfOf(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AncillaryPartyBuilder prune();
    }

    public static class AncillaryPartyImpl
    implements AncillaryParty {
        private final AncillaryRoleEnum role;
        private final List<? extends ReferenceWithMetaParty> partyReference;
        private final CounterpartyRoleEnum onBehalfOf;

        protected AncillaryPartyImpl(AncillaryPartyBuilder builder) {
            this.role = builder.getRole();
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.onBehalfOf = builder.getOnBehalfOf();
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AncillaryRoleEnum getRole() {
            return this.role;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public List<? extends ReferenceWithMetaParty> getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public CounterpartyRoleEnum getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public AncillaryParty build() {
            return this;
        }

        @Override
        public AncillaryPartyBuilder toBuilder() {
            AncillaryPartyBuilder builder = AncillaryParty.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AncillaryPartyBuilder builder) {
            Optional.ofNullable(this.getRole()).ifPresent(builder::setRole);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getOnBehalfOf()).ifPresent(builder::setOnBehalfOf);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AncillaryParty _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.role, (Object)_that.getRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return Objects.equals((Object)this.onBehalfOf, (Object)_that.getOnBehalfOf());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.role != null ? ((Object)((Object)this.role)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? ((Object)((Object)this.onBehalfOf)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AncillaryParty {role=" + (Object)((Object)this.role) + ", partyReference=" + this.partyReference + ", onBehalfOf=" + (Object)((Object)this.onBehalfOf) + '}';
        }
    }
}

