/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Instrument;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstrumentChoice")
@ImplementedBy(value=Default.class)
public interface InstrumentChoice
extends Validator<Instrument> {
    public static final String NAME = "InstrumentChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements InstrumentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instrument instrument) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstrumentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Instrument instrument) {
            ComparisonResult result = this.executeDataRule(instrument);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstrumentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instrument", (RosettaPath)path, (String)InstrumentChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == InstrumentChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstrumentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instrument", (RosettaPath)path, (String)InstrumentChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Instrument instrument) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)instrument), Arrays.asList("ListedDerivative", "Loan", "Security"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

