/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.InstrumentBase;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.PutCallEnum;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.meta.ListedDerivativeMeta;
import cdm.base.staticdata.party.LegalEntity;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ListedDerivative", builder=ListedDerivativeBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ListedDerivative", model="cdm", builder=ListedDerivativeBuilderImpl.class, version="7.0.0-dev.52")
public interface ListedDerivative
extends InstrumentBase {
    public static final ListedDerivativeMeta metaData = new ListedDerivativeMeta();

    public String getDeliveryTerm();

    public PutCallEnum getOptionType();

    public BigDecimal getStrike();

    @Override
    public ListedDerivative build();

    @Override
    public ListedDerivativeBuilder toBuilder();

    public static ListedDerivativeBuilder builder() {
        return new ListedDerivativeBuilderImpl();
    }

    default public RosettaMetaData<? extends ListedDerivative> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ListedDerivative> getType() {
        return ListedDerivative.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strike"), BigDecimal.class, (Object)this.getStrike(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ListedDerivativeBuilderImpl
    extends InstrumentBase.InstrumentBaseBuilderImpl
    implements ListedDerivativeBuilder {
        protected String deliveryTerm;
        protected PutCallEnum optionType;
        protected BigDecimal strike;

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public BigDecimal getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public ListedDerivativeBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public ListedDerivativeBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public ListedDerivativeBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public ListedDerivativeBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public ListedDerivativeBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public ListedDerivativeBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public ListedDerivativeBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public ListedDerivativeBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public ListedDerivativeBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public ListedDerivativeBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public ListedDerivativeBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public ListedDerivativeBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public ListedDerivativeBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public ListedDerivativeBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public ListedDerivativeBuilder setInstrumentType(InstrumentTypeEnum _instrumentType) {
            this.instrumentType = _instrumentType == null ? null : _instrumentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public ListedDerivativeBuilder setDeliveryTerm(String _deliveryTerm) {
            this.deliveryTerm = _deliveryTerm == null ? null : _deliveryTerm;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public ListedDerivativeBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public ListedDerivativeBuilder setStrike(BigDecimal _strike) {
            this.strike = _strike == null ? null : _strike;
            return this;
        }

        @Override
        public ListedDerivative build() {
            return new ListedDerivativeImpl(this);
        }

        @Override
        public ListedDerivativeBuilder toBuilder() {
            return this;
        }

        @Override
        public ListedDerivativeBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryTerm() != null) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            return this.getStrike() != null;
        }

        @Override
        public ListedDerivativeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ListedDerivativeBuilder o = (ListedDerivativeBuilder)other;
            merger.mergeBasic((Object)this.getDeliveryTerm(), (Object)o.getDeliveryTerm(), this::setDeliveryTerm, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrike(), (Object)o.getStrike(), this::setStrike, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ListedDerivative _that = (ListedDerivative)this.getType().cast(o);
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            return Objects.equals(this.strike, _that.getStrike());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ListedDerivativeBuilder {deliveryTerm=" + this.deliveryTerm + ", optionType=" + (Object)((Object)this.optionType) + ", strike=" + this.strike + '}' + " " + super.toString();
        }
    }

    public static interface ListedDerivativeBuilder
    extends ListedDerivative,
    InstrumentBase.InstrumentBaseBuilder {
        @Override
        public ListedDerivativeBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public ListedDerivativeBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public ListedDerivativeBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public ListedDerivativeBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public ListedDerivativeBuilder addTaxonomy(Taxonomy var1);

        @Override
        public ListedDerivativeBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public ListedDerivativeBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public ListedDerivativeBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public ListedDerivativeBuilder setIsExchangeListed(Boolean var1);

        @Override
        public ListedDerivativeBuilder setExchange(LegalEntity var1);

        @Override
        public ListedDerivativeBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public ListedDerivativeBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public ListedDerivativeBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public ListedDerivativeBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public ListedDerivativeBuilder setInstrumentType(InstrumentTypeEnum var1);

        public ListedDerivativeBuilder setDeliveryTerm(String var1);

        public ListedDerivativeBuilder setOptionType(PutCallEnum var1);

        public ListedDerivativeBuilder setStrike(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strike"), BigDecimal.class, (Object)this.getStrike(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ListedDerivativeBuilder prune();
    }

    public static class ListedDerivativeImpl
    extends InstrumentBase.InstrumentBaseImpl
    implements ListedDerivative {
        private final String deliveryTerm;
        private final PutCallEnum optionType;
        private final BigDecimal strike;

        protected ListedDerivativeImpl(ListedDerivativeBuilder builder) {
            super(builder);
            this.deliveryTerm = builder.getDeliveryTerm();
            this.optionType = builder.getOptionType();
            this.strike = builder.getStrike();
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public BigDecimal getStrike() {
            return this.strike;
        }

        @Override
        public ListedDerivative build() {
            return this;
        }

        @Override
        public ListedDerivativeBuilder toBuilder() {
            ListedDerivativeBuilder builder = ListedDerivative.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ListedDerivativeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryTerm()).ifPresent(builder::setDeliveryTerm);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ListedDerivative _that = (ListedDerivative)this.getType().cast(o);
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            return Objects.equals(this.strike, _that.getStrike());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ListedDerivative {deliveryTerm=" + this.deliveryTerm + ", optionType=" + (Object)((Object)this.optionType) + ", strike=" + this.strike + '}' + " " + super.toString();
        }
    }
}

