/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.functions.ToTime;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.inject.Inject;

@ImplementedBy(value=ToDateTimeDefault.class)
public abstract class ToDateTime
implements RosettaFunction {
    @Inject
    protected ToTime toTime;

    public ZonedDateTime evaluate(Date date) {
        ZonedDateTime zonedDateTime = this.doEvaluate(date);
        return zonedDateTime;
    }

    protected abstract ZonedDateTime doEvaluate(Date var1);

    public static class ToDateTimeDefault
    extends ToDateTime {
        @Override
        protected ZonedDateTime doEvaluate(Date date) {
            ZonedDateTime zonedDateTime = null;
            return this.assignOutput(zonedDateTime, date);
        }

        protected ZonedDateTime assignOutput(ZonedDateTime zonedDateTime, Date date) {
            LocalTime time = this.toTime.evaluate(0, 0, 0);
            String timezone = "Z";
            zonedDateTime = date != null && time != null && "Z" != null ? ZonedDateTime.of(date.toLocalDate(), time, ZoneId.of("Z")) : null;
            return zonedDateTime;
        }
    }
}

