/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Swaption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SwaptionChoice")
@ImplementedBy(value=Default.class)
public interface SwaptionChoice
extends Validator<Swaption> {
    public static final String NAME = "SwaptionChoice";
    public static final String DEFINITION = "optional choice cashSettlement, physicalSettlement";

    public static class NoOp
    implements SwaptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Swaption swaption) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SwaptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Swaption swaption) {
            ComparisonResult result = this.executeDataRule(swaption);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SwaptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Swaption", (RosettaPath)path, (String)SwaptionChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SwaptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Swaption", (RosettaPath)path, (String)SwaptionChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Swaption swaption) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)swaption), Arrays.asList("cashSettlement", "physicalSettlement"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

