/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ReplacementValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReplacementValueChoice")
@ImplementedBy(value=Default.class)
public interface ReplacementValueChoice
extends Validator<ReplacementValue> {
    public static final String NAME = "ReplacementValueChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ReplacementValueChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReplacementValue replacementValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReplacementValueChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReplacementValue replacementValue) {
            ComparisonResult result = this.executeDataRule(replacementValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReplacementValueChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReplacementValue", (RosettaPath)path, (String)ReplacementValueChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReplacementValueChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReplacementValue", (RosettaPath)path, (String)ReplacementValueChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReplacementValue replacementValue) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)replacementValue), Arrays.asList("firmQuotations", "calculationAgentDetermination"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

