/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.MaturityNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MaturityNotificationChoice")
@ImplementedBy(value=Default.class)
public interface MaturityNotificationChoice
extends Validator<MaturityNotification> {
    public static final String NAME = "MaturityNotificationChoice";
    public static final String DEFINITION = "required choice optionExpiry, tradeMaturity";

    public static class NoOp
    implements MaturityNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MaturityNotification maturityNotification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MaturityNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MaturityNotification maturityNotification) {
            ComparisonResult result = this.executeDataRule(maturityNotification);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MaturityNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MaturityNotification", (RosettaPath)path, (String)MaturityNotificationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MaturityNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MaturityNotification", (RosettaPath)path, (String)MaturityNotificationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MaturityNotification maturityNotification) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)maturityNotification), Arrays.asList("optionExpiry", "tradeMaturity"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

