/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.LegalActionIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegalActionIdentifierChoice")
@ImplementedBy(value=Default.class)
public interface LegalActionIdentifierChoice
extends Validator<LegalActionIdentifier> {
    public static final String NAME = "LegalActionIdentifierChoice";
    public static final String DEFINITION = "required choice legalActionId, versionedLegalActionId";

    public static class NoOp
    implements LegalActionIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalActionIdentifier legalActionIdentifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegalActionIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalActionIdentifier legalActionIdentifier) {
            ComparisonResult result = this.executeDataRule(legalActionIdentifier);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegalActionIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalActionIdentifier", (RosettaPath)path, (String)LegalActionIdentifierChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegalActionIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalActionIdentifier", (RosettaPath)path, (String)LegalActionIdentifierChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegalActionIdentifier legalActionIdentifier) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)legalActionIdentifier), Arrays.asList("legalActionId", "versionedLegalActionId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

