/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.EquityStrike;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EquityStrikeChoice")
@ImplementedBy(value=Default.class)
public interface EquityStrikeChoice
extends Validator<EquityStrike> {
    public static final String NAME = "EquityStrikeChoice";
    public static final String DEFINITION = "required choice strikePrice, equityStrikeSequence";

    public static class NoOp
    implements EquityStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EquityStrike equityStrike) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EquityStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EquityStrike equityStrike) {
            ComparisonResult result = this.executeDataRule(equityStrike);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EquityStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EquityStrike", (RosettaPath)path, (String)EquityStrikeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EquityStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EquityStrike", (RosettaPath)path, (String)EquityStrikeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EquityStrike equityStrike) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)equityStrike), Arrays.asList("strikePrice", "equityStrikeSequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

