/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.DeliverableObligations;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DeliverableObligationsChoice")
@ImplementedBy(value=Default.class)
public interface DeliverableObligationsChoice
extends Validator<DeliverableObligations> {
    public static final String NAME = "DeliverableObligationsChoice";
    public static final String DEFINITION = "optional choice fullFaithAndCreditObLiability, generalFundObligationLiability , revenueObligationLiability";

    public static class NoOp
    implements DeliverableObligationsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DeliverableObligations deliverableObligations) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DeliverableObligationsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DeliverableObligations deliverableObligations) {
            ComparisonResult result = this.executeDataRule(deliverableObligations);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DeliverableObligationsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DeliverableObligations", (RosettaPath)path, (String)DeliverableObligationsChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DeliverableObligationsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DeliverableObligations", (RosettaPath)path, (String)DeliverableObligationsChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(DeliverableObligations deliverableObligations) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)deliverableObligations), Arrays.asList("fullFaithAndCreditObLiability", "generalFundObligationLiability", "revenueObligationLiability"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

