/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.DealSummary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DealSummaryChoice")
@ImplementedBy(value=Default.class)
public interface DealSummaryChoice
extends Validator<DealSummary> {
    public static final String NAME = "DealSummaryChoice";
    public static final String DEFINITION = "optional choice currency, dealSummarySequence";

    public static class NoOp
    implements DealSummaryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DealSummary dealSummary) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DealSummaryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DealSummary dealSummary) {
            ComparisonResult result = this.executeDataRule(dealSummary);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DealSummaryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DealSummary", (RosettaPath)path, (String)DealSummaryChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DealSummaryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DealSummary", (RosettaPath)path, (String)DealSummaryChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(DealSummary dealSummary) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)dealSummary), Arrays.asList("currency", "dealSummarySequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

