/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ConfirmationStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ConfirmationStatusChoice")
@ImplementedBy(value=Default.class)
public interface ConfirmationStatusChoice
extends Validator<ConfirmationStatus> {
    public static final String NAME = "ConfirmationStatusChoice";
    public static final String DEFINITION = "required choice confirmationStatusSequence, allegedEvent";

    public static class NoOp
    implements ConfirmationStatusChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ConfirmationStatus confirmationStatus) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ConfirmationStatusChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ConfirmationStatus confirmationStatus) {
            ComparisonResult result = this.executeDataRule(confirmationStatus);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ConfirmationStatusChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ConfirmationStatus", (RosettaPath)path, (String)ConfirmationStatusChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ConfirmationStatusChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ConfirmationStatus", (RosettaPath)path, (String)ConfirmationStatusChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ConfirmationStatus confirmationStatus) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)confirmationStatus), Arrays.asList("confirmationStatusSequence", "allegedEvent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

