/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CollateralValuation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CollateralValuationChoice")
@ImplementedBy(value=Default.class)
public interface CollateralValuationChoice
extends Validator<CollateralValuation> {
    public static final String NAME = "CollateralValuationChoice";
    public static final String DEFINITION = "required choice bondCollateralModel, unitContractModel";

    public static class NoOp
    implements CollateralValuationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralValuation collateralValuation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CollateralValuationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralValuation collateralValuation) {
            ComparisonResult result = this.executeDataRule(collateralValuation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CollateralValuationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralValuation", (RosettaPath)path, (String)CollateralValuationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CollateralValuationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralValuation", (RosettaPath)path, (String)CollateralValuationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CollateralValuation collateralValuation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)collateralValuation), Arrays.asList("bondCollateralModel", "unitContractModel"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

