/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ClearingStatusItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ClearingStatusItemChoice")
@ImplementedBy(value=Default.class)
public interface ClearingStatusItemChoice
extends Validator<ClearingStatusItem> {
    public static final String NAME = "ClearingStatusItemChoice";
    public static final String DEFINITION = "required choice tradeIdentifier, tradeReferenceInformationModel , trade , tradePackage";

    public static class NoOp
    implements ClearingStatusItemChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingStatusItem clearingStatusItem) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ClearingStatusItemChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingStatusItem clearingStatusItem) {
            ComparisonResult result = this.executeDataRule(clearingStatusItem);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ClearingStatusItemChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ClearingStatusItem", (RosettaPath)path, (String)ClearingStatusItemChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ClearingStatusItemChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ClearingStatusItem", (RosettaPath)path, (String)ClearingStatusItemChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ClearingStatusItem clearingStatusItem) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)clearingStatusItem), Arrays.asList("tradeIdentifier", "tradeReferenceInformationModel", "trade", "tradePackage"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

