/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.KeyInfoType;
import fpml.confirmation.ObjectType;
import fpml.confirmation.SignatureType;
import fpml.confirmation.SignatureValueType;
import fpml.confirmation.SignedInfoType;
import fpml.confirmation.meta.SignatureMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Signature", builder=SignatureBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Signature", model="fpml", builder=SignatureBuilderImpl.class, version="0.17.2")
public interface Signature
extends SignatureType {
    public static final SignatureMeta metaData = new SignatureMeta();

    @Override
    public Signature build();

    @Override
    public SignatureBuilder toBuilder();

    public static SignatureBuilder builder() {
        return new SignatureBuilderImpl();
    }

    default public RosettaMetaData<? extends Signature> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Signature> getType() {
        return Signature.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("signedInfo"), processor, SignedInfoType.class, this.getSignedInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("signatureValue"), processor, SignatureValueType.class, this.getSignatureValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("keyInfo"), processor, KeyInfoType.class, this.getKeyInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("object"), processor, ObjectType.class, this.getObject(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SignatureBuilderImpl
    extends SignatureType.SignatureTypeBuilderImpl
    implements SignatureBuilder {
        @Override
        @RosettaAttribute(value="signedInfo", isRequired=true)
        @RuneAttribute(value="signedInfo", isRequired=true)
        public SignatureBuilder setSignedInfo(SignedInfoType _signedInfo) {
            this.signedInfo = _signedInfo == null ? null : _signedInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="signatureValue", isRequired=true)
        @RuneAttribute(value="signatureValue", isRequired=true)
        public SignatureBuilder setSignatureValue(SignatureValueType _signatureValue) {
            this.signatureValue = _signatureValue == null ? null : _signatureValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="keyInfo")
        @RuneAttribute(value="keyInfo")
        public SignatureBuilder setKeyInfo(KeyInfoType _keyInfo) {
            this.keyInfo = _keyInfo == null ? null : _keyInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="object")
        @RuneAttribute(value="object")
        public SignatureBuilder addObject(ObjectType _object) {
            if (_object != null) {
                this.object.add(_object.toBuilder());
            }
            return this;
        }

        @Override
        public SignatureBuilder addObject(ObjectType _object, int idx) {
            this.getIndex(this.object, idx, () -> _object.toBuilder());
            return this;
        }

        @Override
        public SignatureBuilder addObject(List<? extends ObjectType> objects) {
            if (objects != null) {
                for (ObjectType objectType : objects) {
                    this.object.add(objectType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="object")
        public SignatureBuilder setObject(List<? extends ObjectType> objects) {
            this.object = objects == null ? new ArrayList() : (List)objects.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SignatureBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Signature build() {
            return new SignatureImpl(this);
        }

        @Override
        public SignatureBuilder toBuilder() {
            return this;
        }

        @Override
        public SignatureBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public SignatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SignatureBuilder o = (SignatureBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "SignatureBuilder {} " + super.toString();
        }
    }

    public static interface SignatureBuilder
    extends Signature,
    SignatureType.SignatureTypeBuilder {
        @Override
        public SignatureBuilder setSignedInfo(SignedInfoType var1);

        @Override
        public SignatureBuilder setSignatureValue(SignatureValueType var1);

        @Override
        public SignatureBuilder setKeyInfo(KeyInfoType var1);

        @Override
        public SignatureBuilder addObject(ObjectType var1);

        @Override
        public SignatureBuilder addObject(ObjectType var1, int var2);

        @Override
        public SignatureBuilder addObject(List<? extends ObjectType> var1);

        @Override
        public SignatureBuilder setObject(List<? extends ObjectType> var1);

        @Override
        public SignatureBuilder setId(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("signedInfo"), processor, SignedInfoType.SignedInfoTypeBuilder.class, (RosettaModelObjectBuilder)this.getSignedInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("signatureValue"), processor, SignatureValueType.SignatureValueTypeBuilder.class, (RosettaModelObjectBuilder)this.getSignatureValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("keyInfo"), processor, KeyInfoType.KeyInfoTypeBuilder.class, (RosettaModelObjectBuilder)this.getKeyInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("object"), processor, ObjectType.ObjectTypeBuilder.class, this.getObject(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public SignatureBuilder prune();
    }

    public static class SignatureImpl
    extends SignatureType.SignatureTypeImpl
    implements Signature {
        protected SignatureImpl(SignatureBuilder builder) {
            super(builder);
        }

        @Override
        public Signature build() {
            return this;
        }

        @Override
        public SignatureBuilder toBuilder() {
            SignatureBuilder builder = Signature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SignatureBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Signature {} " + super.toString();
        }
    }
}

