/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.NotionalAmountReference;
import fpml.confirmation.PaymentRule;
import fpml.confirmation.meta.PercentageRuleMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PercentageRule", builder=PercentageRuleBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PercentageRule", model="fpml", builder=PercentageRuleBuilderImpl.class, version="0.17.2")
public interface PercentageRule
extends PaymentRule {
    public static final PercentageRuleMeta metaData = new PercentageRuleMeta();

    public BigDecimal getPaymentPercent();

    public NotionalAmountReference getNotionalAmountReference();

    @Override
    public PercentageRule build();

    @Override
    public PercentageRuleBuilder toBuilder();

    public static PercentageRuleBuilder builder() {
        return new PercentageRuleBuilderImpl();
    }

    default public RosettaMetaData<? extends PercentageRule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PercentageRule> getType() {
        return PercentageRule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountReference"), processor, NotionalAmountReference.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
    }

    public static class PercentageRuleBuilderImpl
    extends PaymentRule.PaymentRuleBuilderImpl
    implements PercentageRuleBuilder {
        protected BigDecimal paymentPercent;
        protected NotionalAmountReference.NotionalAmountReferenceBuilder notionalAmountReference;

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public NotionalAmountReference.NotionalAmountReferenceBuilder getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public NotionalAmountReference.NotionalAmountReferenceBuilder getOrCreateNotionalAmountReference() {
            NotionalAmountReference.NotionalAmountReferenceBuilder result = this.notionalAmountReference != null ? this.notionalAmountReference : (this.notionalAmountReference = NotionalAmountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public PercentageRuleBuilder setPaymentPercent(BigDecimal _paymentPercent) {
            this.paymentPercent = _paymentPercent == null ? null : _paymentPercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public PercentageRuleBuilder setNotionalAmountReference(NotionalAmountReference _notionalAmountReference) {
            this.notionalAmountReference = _notionalAmountReference == null ? null : _notionalAmountReference.toBuilder();
            return this;
        }

        @Override
        public PercentageRule build() {
            return new PercentageRuleImpl(this);
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            return this;
        }

        @Override
        public PercentageRuleBuilder prune() {
            super.prune();
            if (this.notionalAmountReference != null && !this.notionalAmountReference.prune().hasData()) {
                this.notionalAmountReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentPercent() != null) {
                return true;
            }
            return this.getNotionalAmountReference() != null && this.getNotionalAmountReference().hasData();
        }

        @Override
        public PercentageRuleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PercentageRuleBuilder o = (PercentageRuleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmountReference(), (RosettaModelObjectBuilder)o.getNotionalAmountReference(), this::setNotionalAmountReference);
            merger.mergeBasic((Object)this.getPaymentPercent(), (Object)o.getPaymentPercent(), this::setPaymentPercent, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PercentageRule _that = (PercentageRule)this.getType().cast(o);
            if (!Objects.equals(this.paymentPercent, _that.getPaymentPercent())) {
                return false;
            }
            return Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PercentageRuleBuilder {paymentPercent=" + this.paymentPercent + ", notionalAmountReference=" + this.notionalAmountReference + '}' + " " + super.toString();
        }
    }

    public static interface PercentageRuleBuilder
    extends PercentageRule,
    PaymentRule.PaymentRuleBuilder {
        public NotionalAmountReference.NotionalAmountReferenceBuilder getOrCreateNotionalAmountReference();

        @Override
        public NotionalAmountReference.NotionalAmountReferenceBuilder getNotionalAmountReference();

        public PercentageRuleBuilder setPaymentPercent(BigDecimal var1);

        public PercentageRuleBuilder setNotionalAmountReference(NotionalAmountReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountReference"), processor, NotionalAmountReference.NotionalAmountReferenceBuilder.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
        }

        @Override
        public PercentageRuleBuilder prune();
    }

    public static class PercentageRuleImpl
    extends PaymentRule.PaymentRuleImpl
    implements PercentageRule {
        private final BigDecimal paymentPercent;
        private final NotionalAmountReference notionalAmountReference;

        protected PercentageRuleImpl(PercentageRuleBuilder builder) {
            super(builder);
            this.paymentPercent = builder.getPaymentPercent();
            this.notionalAmountReference = Optional.ofNullable(builder.getNotionalAmountReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public NotionalAmountReference getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public PercentageRule build() {
            return this;
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            PercentageRuleBuilder builder = PercentageRule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PercentageRuleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentPercent()).ifPresent(builder::setPaymentPercent);
            Optional.ofNullable(this.getNotionalAmountReference()).ifPresent(builder::setNotionalAmountReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PercentageRule _that = (PercentageRule)this.getType().cast(o);
            if (!Objects.equals(this.paymentPercent, _that.getPaymentPercent())) {
                return false;
            }
            return Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PercentageRule {paymentPercent=" + this.paymentPercent + ", notionalAmountReference=" + this.notionalAmountReference + '}' + " " + super.toString();
        }
    }
}

