/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.InformationSource;
import fpml.confirmation.meta.ObservedRateMeta;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ObservedRate", builder=ObservedRateBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ObservedRate", model="fpml", builder=ObservedRateBuilderImpl.class, version="0.17.2")
public interface ObservedRate
extends RosettaModelObject {
    public static final ObservedRateMeta metaData = new ObservedRateMeta();

    public BigDecimal getRate();

    public ZonedDateTime getDate();

    public LocalTime getTime();

    public InformationSource getInformationSource();

    public ObservedRate build();

    public ObservedRateBuilder toBuilder();

    public static ObservedRateBuilder builder() {
        return new ObservedRateBuilderImpl();
    }

    default public RosettaMetaData<? extends ObservedRate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ObservedRate> getType() {
        return ObservedRate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
    }

    public static class ObservedRateBuilderImpl
    implements ObservedRateBuilder {
        protected BigDecimal rate;
        protected ZonedDateTime date;
        protected LocalTime time;
        protected InformationSource.InformationSourceBuilder informationSource;

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource.InformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource() {
            InformationSource.InformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = InformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public ObservedRateBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ObservedRateBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ObservedRateBuilder setTime(LocalTime _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public ObservedRateBuilder setInformationSource(InformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        public ObservedRate build() {
            return new ObservedRateImpl(this);
        }

        @Override
        public ObservedRateBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservedRateBuilder prune() {
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRate() != null) {
                return true;
            }
            if (this.getDate() != null) {
                return true;
            }
            if (this.getTime() != null) {
                return true;
            }
            return this.getInformationSource() != null && this.getInformationSource().hasData();
        }

        public ObservedRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservedRateBuilder o = (ObservedRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservedRate _that = this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            return Objects.equals(this.informationSource, _that.getInformationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservedRateBuilder {rate=" + this.rate + ", date=" + this.date + ", time=" + this.time + ", informationSource=" + this.informationSource + '}';
        }
    }

    public static interface ObservedRateBuilder
    extends ObservedRate,
    RosettaModelObjectBuilder {
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource();

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource();

        public ObservedRateBuilder setRate(BigDecimal var1);

        public ObservedRateBuilder setDate(ZonedDateTime var1);

        public ObservedRateBuilder setTime(LocalTime var1);

        public ObservedRateBuilder setInformationSource(InformationSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
        }

        public ObservedRateBuilder prune();
    }

    public static class ObservedRateImpl
    implements ObservedRate {
        private final BigDecimal rate;
        private final ZonedDateTime date;
        private final LocalTime time;
        private final InformationSource informationSource;

        protected ObservedRateImpl(ObservedRateBuilder builder) {
            this.rate = builder.getRate();
            this.date = builder.getDate();
            this.time = builder.getTime();
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        public ObservedRate build() {
            return this;
        }

        @Override
        public ObservedRateBuilder toBuilder() {
            ObservedRateBuilder builder = ObservedRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservedRateBuilder builder) {
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservedRate _that = this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            return Objects.equals(this.informationSource, _that.getInformationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservedRate {rate=" + this.rate + ", date=" + this.date + ", time=" + this.time + ", informationSource=" + this.informationSource + '}';
        }
    }
}

