/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.ExecutionDateTime;
import fpml.confirmation.meta.NovationDatesModelMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="NovationDatesModel", builder=NovationDatesModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="NovationDatesModel", model="fpml", builder=NovationDatesModelBuilderImpl.class, version="0.17.2")
public interface NovationDatesModel
extends RosettaModelObject {
    public static final NovationDatesModelMeta metaData = new NovationDatesModelMeta();

    public ZonedDateTime getNovationDate();

    public ExecutionDateTime getExecutionDateTime();

    public ZonedDateTime getNovationTradeDate();

    public NovationDatesModel build();

    public NovationDatesModelBuilder toBuilder();

    public static NovationDatesModelBuilder builder() {
        return new NovationDatesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends NovationDatesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NovationDatesModel> getType() {
        return NovationDatesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("novationDate"), ZonedDateTime.class, (Object)this.getNovationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.class, this.getExecutionDateTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("novationTradeDate"), ZonedDateTime.class, (Object)this.getNovationTradeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class NovationDatesModelBuilderImpl
    implements NovationDatesModelBuilder {
        protected ZonedDateTime novationDate;
        protected ExecutionDateTime.ExecutionDateTimeBuilder executionDateTime;
        protected ZonedDateTime novationTradeDate;

        @Override
        @RosettaAttribute(value="novationDate", isRequired=true)
        @RuneAttribute(value="novationDate", isRequired=true)
        public ZonedDateTime getNovationDate() {
            return this.novationDate;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime() {
            ExecutionDateTime.ExecutionDateTimeBuilder result = this.executionDateTime != null ? this.executionDateTime : (this.executionDateTime = ExecutionDateTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="novationTradeDate")
        @RuneAttribute(value="novationTradeDate")
        public ZonedDateTime getNovationTradeDate() {
            return this.novationTradeDate;
        }

        @Override
        @RosettaAttribute(value="novationDate", isRequired=true)
        @RuneAttribute(value="novationDate", isRequired=true)
        public NovationDatesModelBuilder setNovationDate(ZonedDateTime _novationDate) {
            this.novationDate = _novationDate == null ? null : _novationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public NovationDatesModelBuilder setExecutionDateTime(ExecutionDateTime _executionDateTime) {
            this.executionDateTime = _executionDateTime == null ? null : _executionDateTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="novationTradeDate")
        @RuneAttribute(value="novationTradeDate")
        public NovationDatesModelBuilder setNovationTradeDate(ZonedDateTime _novationTradeDate) {
            this.novationTradeDate = _novationTradeDate == null ? null : _novationTradeDate;
            return this;
        }

        @Override
        public NovationDatesModel build() {
            return new NovationDatesModelImpl(this);
        }

        @Override
        public NovationDatesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public NovationDatesModelBuilder prune() {
            if (this.executionDateTime != null && !this.executionDateTime.prune().hasData()) {
                this.executionDateTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNovationDate() != null) {
                return true;
            }
            if (this.getExecutionDateTime() != null && this.getExecutionDateTime().hasData()) {
                return true;
            }
            return this.getNovationTradeDate() != null;
        }

        public NovationDatesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NovationDatesModelBuilder o = (NovationDatesModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDateTime(), (RosettaModelObjectBuilder)o.getExecutionDateTime(), this::setExecutionDateTime);
            merger.mergeBasic((Object)this.getNovationDate(), (Object)o.getNovationDate(), this::setNovationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNovationTradeDate(), (Object)o.getNovationTradeDate(), this::setNovationTradeDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NovationDatesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.novationDate, _that.getNovationDate())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            return Objects.equals(this.novationTradeDate, _that.getNovationTradeDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.novationDate != null ? this.novationDate.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.novationTradeDate != null ? this.novationTradeDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NovationDatesModelBuilder {novationDate=" + this.novationDate + ", executionDateTime=" + this.executionDateTime + ", novationTradeDate=" + this.novationTradeDate + '}';
        }
    }

    public static interface NovationDatesModelBuilder
    extends NovationDatesModel,
    RosettaModelObjectBuilder {
        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime();

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime();

        public NovationDatesModelBuilder setNovationDate(ZonedDateTime var1);

        public NovationDatesModelBuilder setExecutionDateTime(ExecutionDateTime var1);

        public NovationDatesModelBuilder setNovationTradeDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("novationDate"), ZonedDateTime.class, (Object)this.getNovationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.ExecutionDateTimeBuilder.class, this.getExecutionDateTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("novationTradeDate"), ZonedDateTime.class, (Object)this.getNovationTradeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public NovationDatesModelBuilder prune();
    }

    public static class NovationDatesModelImpl
    implements NovationDatesModel {
        private final ZonedDateTime novationDate;
        private final ExecutionDateTime executionDateTime;
        private final ZonedDateTime novationTradeDate;

        protected NovationDatesModelImpl(NovationDatesModelBuilder builder) {
            this.novationDate = builder.getNovationDate();
            this.executionDateTime = Optional.ofNullable(builder.getExecutionDateTime()).map(f -> f.build()).orElse(null);
            this.novationTradeDate = builder.getNovationTradeDate();
        }

        @Override
        @RosettaAttribute(value="novationDate", isRequired=true)
        @RuneAttribute(value="novationDate", isRequired=true)
        public ZonedDateTime getNovationDate() {
            return this.novationDate;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        @RosettaAttribute(value="novationTradeDate")
        @RuneAttribute(value="novationTradeDate")
        public ZonedDateTime getNovationTradeDate() {
            return this.novationTradeDate;
        }

        @Override
        public NovationDatesModel build() {
            return this;
        }

        @Override
        public NovationDatesModelBuilder toBuilder() {
            NovationDatesModelBuilder builder = NovationDatesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NovationDatesModelBuilder builder) {
            Optional.ofNullable(this.getNovationDate()).ifPresent(builder::setNovationDate);
            Optional.ofNullable(this.getExecutionDateTime()).ifPresent(builder::setExecutionDateTime);
            Optional.ofNullable(this.getNovationTradeDate()).ifPresent(builder::setNovationTradeDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NovationDatesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.novationDate, _that.getNovationDate())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            return Objects.equals(this.novationTradeDate, _that.getNovationTradeDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.novationDate != null ? this.novationDate.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.novationTradeDate != null ? this.novationTradeDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NovationDatesModel {novationDate=" + this.novationDate + ", executionDateTime=" + this.executionDateTime + ", novationTradeDate=" + this.novationTradeDate + '}';
        }
    }
}

