/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AssetPool;
import fpml.confirmation.BondCalculationModel;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.FixedIncomeSecurityContentModel;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.LegalEntity;
import fpml.confirmation.LegalEntityReference;
import fpml.confirmation.MortgageSector;
import fpml.confirmation.ProductReference;
import fpml.confirmation.UnderlyingAsset;
import fpml.confirmation.meta.MortgageMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Mortgage", builder=MortgageBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Mortgage", model="fpml", builder=MortgageBuilderImpl.class, version="0.17.2")
public interface Mortgage
extends UnderlyingAsset {
    public static final MortgageMeta metaData = new MortgageMeta();

    public LegalEntity getInsurer();

    public LegalEntityReference getInsurerReference();

    public FixedIncomeSecurityContentModel getFixedIncomeSecurityContentModel();

    public BondCalculationModel getBondCalculationModel();

    public BigDecimal getOriginalPrincipalAmount();

    public AssetPool getPool();

    public MortgageSector getSector();

    public String getTranche();

    @Override
    public Mortgage build();

    @Override
    public MortgageBuilder toBuilder();

    public static MortgageBuilder builder() {
        return new MortgageBuilderImpl();
    }

    default public RosettaMetaData<? extends Mortgage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Mortgage> getType() {
        return Mortgage.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("insurer"), processor, LegalEntity.class, this.getInsurer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("insurerReference"), processor, LegalEntityReference.class, this.getInsurerReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.class, this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.class, this.getBondCalculationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalPrincipalAmount"), BigDecimal.class, (Object)this.getOriginalPrincipalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pool"), processor, AssetPool.class, this.getPool(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sector"), processor, MortgageSector.class, this.getSector(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tranche"), String.class, (Object)this.getTranche(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MortgageBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements MortgageBuilder {
        protected LegalEntity.LegalEntityBuilder insurer;
        protected LegalEntityReference.LegalEntityReferenceBuilder insurerReference;
        protected FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder fixedIncomeSecurityContentModel;
        protected BondCalculationModel.BondCalculationModelBuilder bondCalculationModel;
        protected BigDecimal originalPrincipalAmount;
        protected AssetPool.AssetPoolBuilder pool;
        protected MortgageSector.MortgageSectorBuilder sector;
        protected String tranche;

        @Override
        @RosettaAttribute(value="insurer")
        @RuneAttribute(value="insurer")
        public LegalEntity.LegalEntityBuilder getInsurer() {
            return this.insurer;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateInsurer() {
            LegalEntity.LegalEntityBuilder result = this.insurer != null ? this.insurer : (this.insurer = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="insurerReference")
        @RuneAttribute(value="insurerReference")
        public LegalEntityReference.LegalEntityReferenceBuilder getInsurerReference() {
            return this.insurerReference;
        }

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreateInsurerReference() {
            LegalEntityReference.LegalEntityReferenceBuilder result = this.insurerReference != null ? this.insurerReference : (this.insurerReference = LegalEntityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getFixedIncomeSecurityContentModel() {
            return this.fixedIncomeSecurityContentModel;
        }

        @Override
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getOrCreateFixedIncomeSecurityContentModel() {
            FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder result = this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel : (this.fixedIncomeSecurityContentModel = FixedIncomeSecurityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public BondCalculationModel.BondCalculationModelBuilder getBondCalculationModel() {
            return this.bondCalculationModel;
        }

        @Override
        public BondCalculationModel.BondCalculationModelBuilder getOrCreateBondCalculationModel() {
            BondCalculationModel.BondCalculationModelBuilder result = this.bondCalculationModel != null ? this.bondCalculationModel : (this.bondCalculationModel = BondCalculationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originalPrincipalAmount")
        @RuneAttribute(value="originalPrincipalAmount")
        public BigDecimal getOriginalPrincipalAmount() {
            return this.originalPrincipalAmount;
        }

        @Override
        @RosettaAttribute(value="pool")
        @RuneAttribute(value="pool")
        public AssetPool.AssetPoolBuilder getPool() {
            return this.pool;
        }

        @Override
        public AssetPool.AssetPoolBuilder getOrCreatePool() {
            AssetPool.AssetPoolBuilder result = this.pool != null ? this.pool : (this.pool = AssetPool.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sector")
        @RuneAttribute(value="sector")
        public MortgageSector.MortgageSectorBuilder getSector() {
            return this.sector;
        }

        @Override
        public MortgageSector.MortgageSectorBuilder getOrCreateSector() {
            MortgageSector.MortgageSectorBuilder result = this.sector != null ? this.sector : (this.sector = MortgageSector.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public String getTranche() {
            return this.tranche;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public MortgageBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public MortgageBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public MortgageBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public MortgageBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public MortgageBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public MortgageBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public MortgageBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public MortgageBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public MortgageBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public MortgageBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public MortgageBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public MortgageBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public MortgageBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public MortgageBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="insurer")
        @RuneAttribute(value="insurer")
        public MortgageBuilder setInsurer(LegalEntity _insurer) {
            this.insurer = _insurer == null ? null : _insurer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="insurerReference")
        @RuneAttribute(value="insurerReference")
        public MortgageBuilder setInsurerReference(LegalEntityReference _insurerReference) {
            this.insurerReference = _insurerReference == null ? null : _insurerReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public MortgageBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel _fixedIncomeSecurityContentModel) {
            this.fixedIncomeSecurityContentModel = _fixedIncomeSecurityContentModel == null ? null : _fixedIncomeSecurityContentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public MortgageBuilder setBondCalculationModel(BondCalculationModel _bondCalculationModel) {
            this.bondCalculationModel = _bondCalculationModel == null ? null : _bondCalculationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originalPrincipalAmount")
        @RuneAttribute(value="originalPrincipalAmount")
        public MortgageBuilder setOriginalPrincipalAmount(BigDecimal _originalPrincipalAmount) {
            this.originalPrincipalAmount = _originalPrincipalAmount == null ? null : _originalPrincipalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="pool")
        @RuneAttribute(value="pool")
        public MortgageBuilder setPool(AssetPool _pool) {
            this.pool = _pool == null ? null : _pool.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sector")
        @RuneAttribute(value="sector")
        public MortgageBuilder setSector(MortgageSector _sector) {
            this.sector = _sector == null ? null : _sector.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public MortgageBuilder setTranche(String _tranche) {
            this.tranche = _tranche == null ? null : _tranche;
            return this;
        }

        @Override
        public Mortgage build() {
            return new MortgageImpl(this);
        }

        @Override
        public MortgageBuilder toBuilder() {
            return this;
        }

        @Override
        public MortgageBuilder prune() {
            super.prune();
            if (this.insurer != null && !this.insurer.prune().hasData()) {
                this.insurer = null;
            }
            if (this.insurerReference != null && !this.insurerReference.prune().hasData()) {
                this.insurerReference = null;
            }
            if (this.fixedIncomeSecurityContentModel != null && !this.fixedIncomeSecurityContentModel.prune().hasData()) {
                this.fixedIncomeSecurityContentModel = null;
            }
            if (this.bondCalculationModel != null && !this.bondCalculationModel.prune().hasData()) {
                this.bondCalculationModel = null;
            }
            if (this.pool != null && !this.pool.prune().hasData()) {
                this.pool = null;
            }
            if (this.sector != null && !this.sector.prune().hasData()) {
                this.sector = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInsurer() != null && this.getInsurer().hasData()) {
                return true;
            }
            if (this.getInsurerReference() != null && this.getInsurerReference().hasData()) {
                return true;
            }
            if (this.getFixedIncomeSecurityContentModel() != null && this.getFixedIncomeSecurityContentModel().hasData()) {
                return true;
            }
            if (this.getBondCalculationModel() != null && this.getBondCalculationModel().hasData()) {
                return true;
            }
            if (this.getOriginalPrincipalAmount() != null) {
                return true;
            }
            if (this.getPool() != null && this.getPool().hasData()) {
                return true;
            }
            if (this.getSector() != null && this.getSector().hasData()) {
                return true;
            }
            return this.getTranche() != null;
        }

        @Override
        public MortgageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MortgageBuilder o = (MortgageBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInsurer(), (RosettaModelObjectBuilder)o.getInsurer(), this::setInsurer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInsurerReference(), (RosettaModelObjectBuilder)o.getInsurerReference(), this::setInsurerReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedIncomeSecurityContentModel(), (RosettaModelObjectBuilder)o.getFixedIncomeSecurityContentModel(), this::setFixedIncomeSecurityContentModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondCalculationModel(), (RosettaModelObjectBuilder)o.getBondCalculationModel(), this::setBondCalculationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPool(), (RosettaModelObjectBuilder)o.getPool(), this::setPool);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSector(), (RosettaModelObjectBuilder)o.getSector(), this::setSector);
            merger.mergeBasic((Object)this.getOriginalPrincipalAmount(), (Object)o.getOriginalPrincipalAmount(), this::setOriginalPrincipalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTranche(), (Object)o.getTranche(), this::setTranche, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Mortgage _that = (Mortgage)this.getType().cast(o);
            if (!Objects.equals(this.insurer, _that.getInsurer())) {
                return false;
            }
            if (!Objects.equals(this.insurerReference, _that.getInsurerReference())) {
                return false;
            }
            if (!Objects.equals(this.fixedIncomeSecurityContentModel, _that.getFixedIncomeSecurityContentModel())) {
                return false;
            }
            if (!Objects.equals(this.bondCalculationModel, _that.getBondCalculationModel())) {
                return false;
            }
            if (!Objects.equals(this.originalPrincipalAmount, _that.getOriginalPrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.pool, _that.getPool())) {
                return false;
            }
            if (!Objects.equals(this.sector, _that.getSector())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.insurer != null ? this.insurer.hashCode() : 0);
            _result = 31 * _result + (this.insurerReference != null ? this.insurerReference.hashCode() : 0);
            _result = 31 * _result + (this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel.hashCode() : 0);
            _result = 31 * _result + (this.bondCalculationModel != null ? this.bondCalculationModel.hashCode() : 0);
            _result = 31 * _result + (this.originalPrincipalAmount != null ? this.originalPrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.pool != null ? this.pool.hashCode() : 0);
            _result = 31 * _result + (this.sector != null ? this.sector.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MortgageBuilder {insurer=" + this.insurer + ", insurerReference=" + this.insurerReference + ", fixedIncomeSecurityContentModel=" + this.fixedIncomeSecurityContentModel + ", bondCalculationModel=" + this.bondCalculationModel + ", originalPrincipalAmount=" + this.originalPrincipalAmount + ", pool=" + this.pool + ", sector=" + this.sector + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }

    public static interface MortgageBuilder
    extends Mortgage,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateInsurer();

        @Override
        public LegalEntity.LegalEntityBuilder getInsurer();

        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreateInsurerReference();

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getInsurerReference();

        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getOrCreateFixedIncomeSecurityContentModel();

        @Override
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getFixedIncomeSecurityContentModel();

        public BondCalculationModel.BondCalculationModelBuilder getOrCreateBondCalculationModel();

        @Override
        public BondCalculationModel.BondCalculationModelBuilder getBondCalculationModel();

        public AssetPool.AssetPoolBuilder getOrCreatePool();

        @Override
        public AssetPool.AssetPoolBuilder getPool();

        public MortgageSector.MortgageSectorBuilder getOrCreateSector();

        @Override
        public MortgageSector.MortgageSectorBuilder getSector();

        @Override
        public MortgageBuilder setId(String var1);

        @Override
        public MortgageBuilder addInstrumentId(InstrumentId var1);

        @Override
        public MortgageBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public MortgageBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public MortgageBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public MortgageBuilder addInstrumentType(InstrumentType var1);

        @Override
        public MortgageBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public MortgageBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public MortgageBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public MortgageBuilder setDescription(String var1);

        @Override
        public MortgageBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public MortgageBuilder setExchangeId(ExchangeId var1);

        @Override
        public MortgageBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public MortgageBuilder setDefinition(ProductReference var1);

        public MortgageBuilder setInsurer(LegalEntity var1);

        public MortgageBuilder setInsurerReference(LegalEntityReference var1);

        public MortgageBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel var1);

        public MortgageBuilder setBondCalculationModel(BondCalculationModel var1);

        public MortgageBuilder setOriginalPrincipalAmount(BigDecimal var1);

        public MortgageBuilder setPool(AssetPool var1);

        public MortgageBuilder setSector(MortgageSector var1);

        public MortgageBuilder setTranche(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("insurer"), processor, LegalEntity.LegalEntityBuilder.class, this.getInsurer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("insurerReference"), processor, LegalEntityReference.LegalEntityReferenceBuilder.class, this.getInsurerReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder.class, this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.BondCalculationModelBuilder.class, this.getBondCalculationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalPrincipalAmount"), BigDecimal.class, (Object)this.getOriginalPrincipalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pool"), processor, AssetPool.AssetPoolBuilder.class, this.getPool(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sector"), processor, MortgageSector.MortgageSectorBuilder.class, this.getSector(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tranche"), String.class, (Object)this.getTranche(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MortgageBuilder prune();
    }

    public static class MortgageImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements Mortgage {
        private final LegalEntity insurer;
        private final LegalEntityReference insurerReference;
        private final FixedIncomeSecurityContentModel fixedIncomeSecurityContentModel;
        private final BondCalculationModel bondCalculationModel;
        private final BigDecimal originalPrincipalAmount;
        private final AssetPool pool;
        private final MortgageSector sector;
        private final String tranche;

        protected MortgageImpl(MortgageBuilder builder) {
            super(builder);
            this.insurer = Optional.ofNullable(builder.getInsurer()).map(f -> f.build()).orElse(null);
            this.insurerReference = Optional.ofNullable(builder.getInsurerReference()).map(f -> f.build()).orElse(null);
            this.fixedIncomeSecurityContentModel = Optional.ofNullable(builder.getFixedIncomeSecurityContentModel()).map(f -> f.build()).orElse(null);
            this.bondCalculationModel = Optional.ofNullable(builder.getBondCalculationModel()).map(f -> f.build()).orElse(null);
            this.originalPrincipalAmount = builder.getOriginalPrincipalAmount();
            this.pool = Optional.ofNullable(builder.getPool()).map(f -> f.build()).orElse(null);
            this.sector = Optional.ofNullable(builder.getSector()).map(f -> f.build()).orElse(null);
            this.tranche = builder.getTranche();
        }

        @Override
        @RosettaAttribute(value="insurer")
        @RuneAttribute(value="insurer")
        public LegalEntity getInsurer() {
            return this.insurer;
        }

        @Override
        @RosettaAttribute(value="insurerReference")
        @RuneAttribute(value="insurerReference")
        public LegalEntityReference getInsurerReference() {
            return this.insurerReference;
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public FixedIncomeSecurityContentModel getFixedIncomeSecurityContentModel() {
            return this.fixedIncomeSecurityContentModel;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public BondCalculationModel getBondCalculationModel() {
            return this.bondCalculationModel;
        }

        @Override
        @RosettaAttribute(value="originalPrincipalAmount")
        @RuneAttribute(value="originalPrincipalAmount")
        public BigDecimal getOriginalPrincipalAmount() {
            return this.originalPrincipalAmount;
        }

        @Override
        @RosettaAttribute(value="pool")
        @RuneAttribute(value="pool")
        public AssetPool getPool() {
            return this.pool;
        }

        @Override
        @RosettaAttribute(value="sector")
        @RuneAttribute(value="sector")
        public MortgageSector getSector() {
            return this.sector;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public String getTranche() {
            return this.tranche;
        }

        @Override
        public Mortgage build() {
            return this;
        }

        @Override
        public MortgageBuilder toBuilder() {
            MortgageBuilder builder = Mortgage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MortgageBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInsurer()).ifPresent(builder::setInsurer);
            Optional.ofNullable(this.getInsurerReference()).ifPresent(builder::setInsurerReference);
            Optional.ofNullable(this.getFixedIncomeSecurityContentModel()).ifPresent(builder::setFixedIncomeSecurityContentModel);
            Optional.ofNullable(this.getBondCalculationModel()).ifPresent(builder::setBondCalculationModel);
            Optional.ofNullable(this.getOriginalPrincipalAmount()).ifPresent(builder::setOriginalPrincipalAmount);
            Optional.ofNullable(this.getPool()).ifPresent(builder::setPool);
            Optional.ofNullable(this.getSector()).ifPresent(builder::setSector);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Mortgage _that = (Mortgage)this.getType().cast(o);
            if (!Objects.equals(this.insurer, _that.getInsurer())) {
                return false;
            }
            if (!Objects.equals(this.insurerReference, _that.getInsurerReference())) {
                return false;
            }
            if (!Objects.equals(this.fixedIncomeSecurityContentModel, _that.getFixedIncomeSecurityContentModel())) {
                return false;
            }
            if (!Objects.equals(this.bondCalculationModel, _that.getBondCalculationModel())) {
                return false;
            }
            if (!Objects.equals(this.originalPrincipalAmount, _that.getOriginalPrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.pool, _that.getPool())) {
                return false;
            }
            if (!Objects.equals(this.sector, _that.getSector())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.insurer != null ? this.insurer.hashCode() : 0);
            _result = 31 * _result + (this.insurerReference != null ? this.insurerReference.hashCode() : 0);
            _result = 31 * _result + (this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel.hashCode() : 0);
            _result = 31 * _result + (this.bondCalculationModel != null ? this.bondCalculationModel.hashCode() : 0);
            _result = 31 * _result + (this.originalPrincipalAmount != null ? this.originalPrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.pool != null ? this.pool.hashCode() : 0);
            _result = 31 * _result + (this.sector != null ? this.sector.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Mortgage {insurer=" + this.insurer + ", insurerReference=" + this.insurerReference + ", fixedIncomeSecurityContentModel=" + this.fixedIncomeSecurityContentModel + ", bondCalculationModel=" + this.bondCalculationModel + ", originalPrincipalAmount=" + this.originalPrincipalAmount + ", pool=" + this.pool + ", sector=" + this.sector + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }
}

