/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AccrualPeriod;
import fpml.confirmation.UtilizationPeriod;
import fpml.confirmation.meta.LoanTradingCostOfCarryAccrualMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradingCostOfCarryAccrual", builder=LoanTradingCostOfCarryAccrualBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanTradingCostOfCarryAccrual", model="fpml", builder=LoanTradingCostOfCarryAccrualBuilderImpl.class, version="0.17.2")
public interface LoanTradingCostOfCarryAccrual
extends RosettaModelObject {
    public static final LoanTradingCostOfCarryAccrualMeta metaData = new LoanTradingCostOfCarryAccrualMeta();

    public List<? extends UtilizationPeriod> getUtilizationPeriod();

    public AccrualPeriod getCommencementAccrual();

    public List<? extends AccrualPeriod> getSettlementPeriodAccrual();

    public LoanTradingCostOfCarryAccrual build();

    public LoanTradingCostOfCarryAccrualBuilder toBuilder();

    public static LoanTradingCostOfCarryAccrualBuilder builder() {
        return new LoanTradingCostOfCarryAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingCostOfCarryAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingCostOfCarryAccrual> getType() {
        return LoanTradingCostOfCarryAccrual.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("utilizationPeriod"), processor, UtilizationPeriod.class, this.getUtilizationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commencementAccrual"), processor, AccrualPeriod.class, this.getCommencementAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodAccrual"), processor, AccrualPeriod.class, this.getSettlementPeriodAccrual(), new AttributeMeta[0]);
    }

    public static class LoanTradingCostOfCarryAccrualBuilderImpl
    implements LoanTradingCostOfCarryAccrualBuilder {
        protected List<UtilizationPeriod.UtilizationPeriodBuilder> utilizationPeriod = new ArrayList<UtilizationPeriod.UtilizationPeriodBuilder>();
        protected AccrualPeriod.AccrualPeriodBuilder commencementAccrual;
        protected List<AccrualPeriod.AccrualPeriodBuilder> settlementPeriodAccrual = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();

        @Override
        @RosettaAttribute(value="utilizationPeriod", isRequired=true)
        @RuneAttribute(value="utilizationPeriod", isRequired=true)
        public List<? extends UtilizationPeriod.UtilizationPeriodBuilder> getUtilizationPeriod() {
            return this.utilizationPeriod;
        }

        @Override
        public UtilizationPeriod.UtilizationPeriodBuilder getOrCreateUtilizationPeriod(int index) {
            if (this.utilizationPeriod == null) {
                this.utilizationPeriod = new ArrayList<UtilizationPeriod.UtilizationPeriodBuilder>();
            }
            return (UtilizationPeriod.UtilizationPeriodBuilder)this.getIndex(this.utilizationPeriod, index, () -> {
                UtilizationPeriod.UtilizationPeriodBuilder newUtilizationPeriod = UtilizationPeriod.builder();
                return newUtilizationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="commencementAccrual")
        @RuneAttribute(value="commencementAccrual")
        public AccrualPeriod.AccrualPeriodBuilder getCommencementAccrual() {
            return this.commencementAccrual;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateCommencementAccrual() {
            AccrualPeriod.AccrualPeriodBuilder result = this.commencementAccrual != null ? this.commencementAccrual : (this.commencementAccrual = AccrualPeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodAccrual")
        @RuneAttribute(value="settlementPeriodAccrual")
        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getSettlementPeriodAccrual() {
            return this.settlementPeriodAccrual;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateSettlementPeriodAccrual(int index) {
            if (this.settlementPeriodAccrual == null) {
                this.settlementPeriodAccrual = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
            }
            return (AccrualPeriod.AccrualPeriodBuilder)this.getIndex(this.settlementPeriodAccrual, index, () -> {
                AccrualPeriod.AccrualPeriodBuilder newSettlementPeriodAccrual = AccrualPeriod.builder();
                return newSettlementPeriodAccrual;
            });
        }

        @Override
        @RosettaAttribute(value="utilizationPeriod", isRequired=true)
        @RuneAttribute(value="utilizationPeriod", isRequired=true)
        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(UtilizationPeriod _utilizationPeriod) {
            if (_utilizationPeriod != null) {
                this.utilizationPeriod.add(_utilizationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(UtilizationPeriod _utilizationPeriod, int idx) {
            this.getIndex(this.utilizationPeriod, idx, () -> _utilizationPeriod.toBuilder());
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(List<? extends UtilizationPeriod> utilizationPeriods) {
            if (utilizationPeriods != null) {
                for (UtilizationPeriod utilizationPeriod : utilizationPeriods) {
                    this.utilizationPeriod.add(utilizationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="utilizationPeriod")
        public LoanTradingCostOfCarryAccrualBuilder setUtilizationPeriod(List<? extends UtilizationPeriod> utilizationPeriods) {
            this.utilizationPeriod = utilizationPeriods == null ? new ArrayList<UtilizationPeriod.UtilizationPeriodBuilder>() : (List)utilizationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commencementAccrual")
        @RuneAttribute(value="commencementAccrual")
        public LoanTradingCostOfCarryAccrualBuilder setCommencementAccrual(AccrualPeriod _commencementAccrual) {
            this.commencementAccrual = _commencementAccrual == null ? null : _commencementAccrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodAccrual")
        @RuneAttribute(value="settlementPeriodAccrual")
        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(AccrualPeriod _settlementPeriodAccrual) {
            if (_settlementPeriodAccrual != null) {
                this.settlementPeriodAccrual.add(_settlementPeriodAccrual.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(AccrualPeriod _settlementPeriodAccrual, int idx) {
            this.getIndex(this.settlementPeriodAccrual, idx, () -> _settlementPeriodAccrual.toBuilder());
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(List<? extends AccrualPeriod> settlementPeriodAccruals) {
            if (settlementPeriodAccruals != null) {
                for (AccrualPeriod accrualPeriod : settlementPeriodAccruals) {
                    this.settlementPeriodAccrual.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriodAccrual")
        public LoanTradingCostOfCarryAccrualBuilder setSettlementPeriodAccrual(List<? extends AccrualPeriod> settlementPeriodAccruals) {
            this.settlementPeriodAccrual = settlementPeriodAccruals == null ? new ArrayList<AccrualPeriod.AccrualPeriodBuilder>() : (List)settlementPeriodAccruals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrual build() {
            return new LoanTradingCostOfCarryAccrualImpl(this);
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder prune() {
            this.utilizationPeriod = this.utilizationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commencementAccrual != null && !this.commencementAccrual.prune().hasData()) {
                this.commencementAccrual = null;
            }
            this.settlementPeriodAccrual = this.settlementPeriodAccrual.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getUtilizationPeriod() != null && this.getUtilizationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCommencementAccrual() != null && this.getCommencementAccrual().hasData()) {
                return true;
            }
            return this.getSettlementPeriodAccrual() != null && this.getSettlementPeriodAccrual().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanTradingCostOfCarryAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradingCostOfCarryAccrualBuilder o = (LoanTradingCostOfCarryAccrualBuilder)other;
            merger.mergeRosetta(this.getUtilizationPeriod(), o.getUtilizationPeriod(), this::getOrCreateUtilizationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommencementAccrual(), (RosettaModelObjectBuilder)o.getCommencementAccrual(), this::setCommencementAccrual);
            merger.mergeRosetta(this.getSettlementPeriodAccrual(), o.getSettlementPeriodAccrual(), this::getOrCreateSettlementPeriodAccrual);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCostOfCarryAccrual _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.utilizationPeriod, _that.getUtilizationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.commencementAccrual, _that.getCommencementAccrual())) {
                return false;
            }
            return ListEquals.listEquals(this.settlementPeriodAccrual, _that.getSettlementPeriodAccrual());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.utilizationPeriod != null ? this.utilizationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.commencementAccrual != null ? this.commencementAccrual.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodAccrual != null ? this.settlementPeriodAccrual.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCostOfCarryAccrualBuilder {utilizationPeriod=" + this.utilizationPeriod + ", commencementAccrual=" + this.commencementAccrual + ", settlementPeriodAccrual=" + this.settlementPeriodAccrual + '}';
        }
    }

    public static interface LoanTradingCostOfCarryAccrualBuilder
    extends LoanTradingCostOfCarryAccrual,
    RosettaModelObjectBuilder {
        public UtilizationPeriod.UtilizationPeriodBuilder getOrCreateUtilizationPeriod(int var1);

        public List<? extends UtilizationPeriod.UtilizationPeriodBuilder> getUtilizationPeriod();

        public AccrualPeriod.AccrualPeriodBuilder getOrCreateCommencementAccrual();

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getCommencementAccrual();

        public AccrualPeriod.AccrualPeriodBuilder getOrCreateSettlementPeriodAccrual(int var1);

        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getSettlementPeriodAccrual();

        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(UtilizationPeriod var1);

        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(UtilizationPeriod var1, int var2);

        public LoanTradingCostOfCarryAccrualBuilder addUtilizationPeriod(List<? extends UtilizationPeriod> var1);

        public LoanTradingCostOfCarryAccrualBuilder setUtilizationPeriod(List<? extends UtilizationPeriod> var1);

        public LoanTradingCostOfCarryAccrualBuilder setCommencementAccrual(AccrualPeriod var1);

        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(AccrualPeriod var1);

        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(AccrualPeriod var1, int var2);

        public LoanTradingCostOfCarryAccrualBuilder addSettlementPeriodAccrual(List<? extends AccrualPeriod> var1);

        public LoanTradingCostOfCarryAccrualBuilder setSettlementPeriodAccrual(List<? extends AccrualPeriod> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("utilizationPeriod"), processor, UtilizationPeriod.UtilizationPeriodBuilder.class, this.getUtilizationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commencementAccrual"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getCommencementAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodAccrual"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getSettlementPeriodAccrual(), new AttributeMeta[0]);
        }

        public LoanTradingCostOfCarryAccrualBuilder prune();
    }

    public static class LoanTradingCostOfCarryAccrualImpl
    implements LoanTradingCostOfCarryAccrual {
        private final List<? extends UtilizationPeriod> utilizationPeriod;
        private final AccrualPeriod commencementAccrual;
        private final List<? extends AccrualPeriod> settlementPeriodAccrual;

        protected LoanTradingCostOfCarryAccrualImpl(LoanTradingCostOfCarryAccrualBuilder builder) {
            this.utilizationPeriod = Optional.ofNullable(builder.getUtilizationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commencementAccrual = Optional.ofNullable(builder.getCommencementAccrual()).map(f -> f.build()).orElse(null);
            this.settlementPeriodAccrual = Optional.ofNullable(builder.getSettlementPeriodAccrual()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="utilizationPeriod", isRequired=true)
        @RuneAttribute(value="utilizationPeriod", isRequired=true)
        public List<? extends UtilizationPeriod> getUtilizationPeriod() {
            return this.utilizationPeriod;
        }

        @Override
        @RosettaAttribute(value="commencementAccrual")
        @RuneAttribute(value="commencementAccrual")
        public AccrualPeriod getCommencementAccrual() {
            return this.commencementAccrual;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodAccrual")
        @RuneAttribute(value="settlementPeriodAccrual")
        public List<? extends AccrualPeriod> getSettlementPeriodAccrual() {
            return this.settlementPeriodAccrual;
        }

        @Override
        public LoanTradingCostOfCarryAccrual build() {
            return this;
        }

        @Override
        public LoanTradingCostOfCarryAccrualBuilder toBuilder() {
            LoanTradingCostOfCarryAccrualBuilder builder = LoanTradingCostOfCarryAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingCostOfCarryAccrualBuilder builder) {
            Optional.ofNullable(this.getUtilizationPeriod()).ifPresent(builder::setUtilizationPeriod);
            Optional.ofNullable(this.getCommencementAccrual()).ifPresent(builder::setCommencementAccrual);
            Optional.ofNullable(this.getSettlementPeriodAccrual()).ifPresent(builder::setSettlementPeriodAccrual);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCostOfCarryAccrual _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.utilizationPeriod, _that.getUtilizationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.commencementAccrual, _that.getCommencementAccrual())) {
                return false;
            }
            return ListEquals.listEquals(this.settlementPeriodAccrual, _that.getSettlementPeriodAccrual());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.utilizationPeriod != null ? this.utilizationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.commencementAccrual != null ? this.commencementAccrual.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodAccrual != null ? this.settlementPeriodAccrual.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCostOfCarryAccrual {utilizationPeriod=" + this.utilizationPeriod + ", commencementAccrual=" + this.commencementAccrual + ", settlementPeriodAccrual=" + this.settlementPeriodAccrual + '}';
        }
    }
}

