/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.LegalActionId;
import fpml.confirmation.PartyReference;
import fpml.confirmation.VersionedLegalActionId;
import fpml.confirmation.meta.LegalActionIdentifierMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegalActionIdentifier", builder=LegalActionIdentifierBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LegalActionIdentifier", model="fpml", builder=LegalActionIdentifierBuilderImpl.class, version="0.17.2")
public interface LegalActionIdentifier
extends RosettaModelObject {
    public static final LegalActionIdentifierMeta metaData = new LegalActionIdentifierMeta();

    public String getName();

    public PartyReference getPartyReference();

    public List<? extends LegalActionId> getLegalActionId();

    public List<? extends VersionedLegalActionId> getVersionedLegalActionId();

    public String getId();

    public LegalActionIdentifier build();

    public LegalActionIdentifierBuilder toBuilder();

    public static LegalActionIdentifierBuilder builder() {
        return new LegalActionIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends LegalActionIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegalActionIdentifier> getType() {
        return LegalActionIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.class, this.getLegalActionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LegalActionIdentifierBuilderImpl
    implements LegalActionIdentifierBuilder {
        protected String name;
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<LegalActionId.LegalActionIdBuilder> legalActionId = new ArrayList<LegalActionId.LegalActionIdBuilder>();
        protected List<VersionedLegalActionId.VersionedLegalActionIdBuilder> versionedLegalActionId = new ArrayList<VersionedLegalActionId.VersionedLegalActionIdBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legalActionId")
        @RuneAttribute(value="legalActionId")
        public List<? extends LegalActionId.LegalActionIdBuilder> getLegalActionId() {
            return this.legalActionId;
        }

        @Override
        public LegalActionId.LegalActionIdBuilder getOrCreateLegalActionId(int index) {
            if (this.legalActionId == null) {
                this.legalActionId = new ArrayList<LegalActionId.LegalActionIdBuilder>();
            }
            return (LegalActionId.LegalActionIdBuilder)this.getIndex(this.legalActionId, index, () -> {
                LegalActionId.LegalActionIdBuilder newLegalActionId = LegalActionId.builder();
                return newLegalActionId;
            });
        }

        @Override
        @RosettaAttribute(value="versionedLegalActionId")
        @RuneAttribute(value="versionedLegalActionId")
        public List<? extends VersionedLegalActionId.VersionedLegalActionIdBuilder> getVersionedLegalActionId() {
            return this.versionedLegalActionId;
        }

        @Override
        public VersionedLegalActionId.VersionedLegalActionIdBuilder getOrCreateVersionedLegalActionId(int index) {
            if (this.versionedLegalActionId == null) {
                this.versionedLegalActionId = new ArrayList<VersionedLegalActionId.VersionedLegalActionIdBuilder>();
            }
            return (VersionedLegalActionId.VersionedLegalActionIdBuilder)this.getIndex(this.versionedLegalActionId, index, () -> {
                VersionedLegalActionId.VersionedLegalActionIdBuilder newVersionedLegalActionId = VersionedLegalActionId.builder();
                return newVersionedLegalActionId;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public LegalActionIdentifierBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LegalActionIdentifierBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionId")
        @RuneAttribute(value="legalActionId")
        public LegalActionIdentifierBuilder addLegalActionId(LegalActionId _legalActionId) {
            if (_legalActionId != null) {
                this.legalActionId.add(_legalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder addLegalActionId(LegalActionId _legalActionId, int idx) {
            this.getIndex(this.legalActionId, idx, () -> _legalActionId.toBuilder());
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder addLegalActionId(List<? extends LegalActionId> legalActionIds) {
            if (legalActionIds != null) {
                for (LegalActionId legalActionId : legalActionIds) {
                    this.legalActionId.add(legalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legalActionId")
        public LegalActionIdentifierBuilder setLegalActionId(List<? extends LegalActionId> legalActionIds) {
            this.legalActionId = legalActionIds == null ? new ArrayList<LegalActionId.LegalActionIdBuilder>() : (List)legalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedLegalActionId")
        @RuneAttribute(value="versionedLegalActionId")
        public LegalActionIdentifierBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId) {
            if (_versionedLegalActionId != null) {
                this.versionedLegalActionId.add(_versionedLegalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId, int idx) {
            this.getIndex(this.versionedLegalActionId, idx, () -> _versionedLegalActionId.toBuilder());
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            if (versionedLegalActionIds != null) {
                for (VersionedLegalActionId versionedLegalActionId : versionedLegalActionIds) {
                    this.versionedLegalActionId.add(versionedLegalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedLegalActionId")
        public LegalActionIdentifierBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            this.versionedLegalActionId = versionedLegalActionIds == null ? new ArrayList<VersionedLegalActionId.VersionedLegalActionIdBuilder>() : (List)versionedLegalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LegalActionIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public LegalActionIdentifier build() {
            return new LegalActionIdentifierImpl(this);
        }

        @Override
        public LegalActionIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.legalActionId = this.legalActionId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.versionedLegalActionId = this.versionedLegalActionId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getLegalActionId() != null && this.getLegalActionId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getVersionedLegalActionId() != null && this.getVersionedLegalActionId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public LegalActionIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegalActionIdentifierBuilder o = (LegalActionIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getLegalActionId(), o.getLegalActionId(), this::getOrCreateLegalActionId);
            merger.mergeRosetta(this.getVersionedLegalActionId(), o.getVersionedLegalActionId(), this::getOrCreateVersionedLegalActionId);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalActionIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legalActionId, _that.getLegalActionId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedLegalActionId, _that.getVersionedLegalActionId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.legalActionId != null ? this.legalActionId.hashCode() : 0);
            _result = 31 * _result + (this.versionedLegalActionId != null ? this.versionedLegalActionId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalActionIdentifierBuilder {name=" + this.name + ", partyReference=" + this.partyReference + ", legalActionId=" + this.legalActionId + ", versionedLegalActionId=" + this.versionedLegalActionId + ", id=" + this.id + '}';
        }
    }

    public static interface LegalActionIdentifierBuilder
    extends LegalActionIdentifier,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public LegalActionId.LegalActionIdBuilder getOrCreateLegalActionId(int var1);

        public List<? extends LegalActionId.LegalActionIdBuilder> getLegalActionId();

        public VersionedLegalActionId.VersionedLegalActionIdBuilder getOrCreateVersionedLegalActionId(int var1);

        public List<? extends VersionedLegalActionId.VersionedLegalActionIdBuilder> getVersionedLegalActionId();

        public LegalActionIdentifierBuilder setName(String var1);

        public LegalActionIdentifierBuilder setPartyReference(PartyReference var1);

        public LegalActionIdentifierBuilder addLegalActionId(LegalActionId var1);

        public LegalActionIdentifierBuilder addLegalActionId(LegalActionId var1, int var2);

        public LegalActionIdentifierBuilder addLegalActionId(List<? extends LegalActionId> var1);

        public LegalActionIdentifierBuilder setLegalActionId(List<? extends LegalActionId> var1);

        public LegalActionIdentifierBuilder addVersionedLegalActionId(VersionedLegalActionId var1);

        public LegalActionIdentifierBuilder addVersionedLegalActionId(VersionedLegalActionId var1, int var2);

        public LegalActionIdentifierBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        public LegalActionIdentifierBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        public LegalActionIdentifierBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.LegalActionIdBuilder.class, this.getLegalActionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.VersionedLegalActionIdBuilder.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public LegalActionIdentifierBuilder prune();
    }

    public static class LegalActionIdentifierImpl
    implements LegalActionIdentifier {
        private final String name;
        private final PartyReference partyReference;
        private final List<? extends LegalActionId> legalActionId;
        private final List<? extends VersionedLegalActionId> versionedLegalActionId;
        private final String id;

        protected LegalActionIdentifierImpl(LegalActionIdentifierBuilder builder) {
            this.name = builder.getName();
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.legalActionId = Optional.ofNullable(builder.getLegalActionId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.versionedLegalActionId = Optional.ofNullable(builder.getVersionedLegalActionId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="legalActionId")
        @RuneAttribute(value="legalActionId")
        public List<? extends LegalActionId> getLegalActionId() {
            return this.legalActionId;
        }

        @Override
        @RosettaAttribute(value="versionedLegalActionId")
        @RuneAttribute(value="versionedLegalActionId")
        public List<? extends VersionedLegalActionId> getVersionedLegalActionId() {
            return this.versionedLegalActionId;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public LegalActionIdentifier build() {
            return this;
        }

        @Override
        public LegalActionIdentifierBuilder toBuilder() {
            LegalActionIdentifierBuilder builder = LegalActionIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalActionIdentifierBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getLegalActionId()).ifPresent(builder::setLegalActionId);
            Optional.ofNullable(this.getVersionedLegalActionId()).ifPresent(builder::setVersionedLegalActionId);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalActionIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legalActionId, _that.getLegalActionId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedLegalActionId, _that.getVersionedLegalActionId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.legalActionId != null ? this.legalActionId.hashCode() : 0);
            _result = 31 * _result + (this.versionedLegalActionId != null ? this.versionedLegalActionId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalActionIdentifier {name=" + this.name + ", partyReference=" + this.partyReference + ", legalActionId=" + this.legalActionId + ", versionedLegalActionId=" + this.versionedLegalActionId + ", id=" + this.id + '}';
        }
    }
}

