/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.IssuerId;
import fpml.confirmation.TradeId;
import fpml.confirmation.meta.IssuerTradeIdModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="IssuerTradeIdModel", builder=IssuerTradeIdModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="IssuerTradeIdModel", model="fpml", builder=IssuerTradeIdModelBuilderImpl.class, version="0.17.2")
public interface IssuerTradeIdModel
extends RosettaModelObject {
    public static final IssuerTradeIdModelMeta metaData = new IssuerTradeIdModelMeta();

    public IssuerId getIssuer();

    public TradeId getTradeId();

    public IssuerTradeIdModel build();

    public IssuerTradeIdModelBuilder toBuilder();

    public static IssuerTradeIdModelBuilder builder() {
        return new IssuerTradeIdModelBuilderImpl();
    }

    default public RosettaMetaData<? extends IssuerTradeIdModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IssuerTradeIdModel> getType() {
        return IssuerTradeIdModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuer"), processor, IssuerId.class, this.getIssuer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.class, this.getTradeId(), new AttributeMeta[0]);
    }

    public static class IssuerTradeIdModelBuilderImpl
    implements IssuerTradeIdModelBuilder {
        protected IssuerId.IssuerIdBuilder issuer;
        protected TradeId.TradeIdBuilder tradeId;

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public IssuerId.IssuerIdBuilder getIssuer() {
            return this.issuer;
        }

        @Override
        public IssuerId.IssuerIdBuilder getOrCreateIssuer() {
            IssuerId.IssuerIdBuilder result = this.issuer != null ? this.issuer : (this.issuer = IssuerId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public TradeId.TradeIdBuilder getTradeId() {
            return this.tradeId;
        }

        @Override
        public TradeId.TradeIdBuilder getOrCreateTradeId() {
            TradeId.TradeIdBuilder result = this.tradeId != null ? this.tradeId : (this.tradeId = TradeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public IssuerTradeIdModelBuilder setIssuer(IssuerId _issuer) {
            this.issuer = _issuer == null ? null : _issuer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public IssuerTradeIdModelBuilder setTradeId(TradeId _tradeId) {
            this.tradeId = _tradeId == null ? null : _tradeId.toBuilder();
            return this;
        }

        @Override
        public IssuerTradeIdModel build() {
            return new IssuerTradeIdModelImpl(this);
        }

        @Override
        public IssuerTradeIdModelBuilder toBuilder() {
            return this;
        }

        @Override
        public IssuerTradeIdModelBuilder prune() {
            if (this.issuer != null && !this.issuer.prune().hasData()) {
                this.issuer = null;
            }
            if (this.tradeId != null && !this.tradeId.prune().hasData()) {
                this.tradeId = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIssuer() != null && this.getIssuer().hasData()) {
                return true;
            }
            return this.getTradeId() != null && this.getTradeId().hasData();
        }

        public IssuerTradeIdModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IssuerTradeIdModelBuilder o = (IssuerTradeIdModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuer(), (RosettaModelObjectBuilder)o.getIssuer(), this::setIssuer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeId(), (RosettaModelObjectBuilder)o.getTradeId(), this::setTradeId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerTradeIdModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            return Objects.equals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerTradeIdModelBuilder {issuer=" + this.issuer + ", tradeId=" + this.tradeId + '}';
        }
    }

    public static interface IssuerTradeIdModelBuilder
    extends IssuerTradeIdModel,
    RosettaModelObjectBuilder {
        public IssuerId.IssuerIdBuilder getOrCreateIssuer();

        @Override
        public IssuerId.IssuerIdBuilder getIssuer();

        public TradeId.TradeIdBuilder getOrCreateTradeId();

        @Override
        public TradeId.TradeIdBuilder getTradeId();

        public IssuerTradeIdModelBuilder setIssuer(IssuerId var1);

        public IssuerTradeIdModelBuilder setTradeId(TradeId var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuer"), processor, IssuerId.IssuerIdBuilder.class, this.getIssuer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.TradeIdBuilder.class, this.getTradeId(), new AttributeMeta[0]);
        }

        public IssuerTradeIdModelBuilder prune();
    }

    public static class IssuerTradeIdModelImpl
    implements IssuerTradeIdModel {
        private final IssuerId issuer;
        private final TradeId tradeId;

        protected IssuerTradeIdModelImpl(IssuerTradeIdModelBuilder builder) {
            this.issuer = Optional.ofNullable(builder.getIssuer()).map(f -> f.build()).orElse(null);
            this.tradeId = Optional.ofNullable(builder.getTradeId()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public IssuerId getIssuer() {
            return this.issuer;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public TradeId getTradeId() {
            return this.tradeId;
        }

        @Override
        public IssuerTradeIdModel build() {
            return this;
        }

        @Override
        public IssuerTradeIdModelBuilder toBuilder() {
            IssuerTradeIdModelBuilder builder = IssuerTradeIdModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IssuerTradeIdModelBuilder builder) {
            Optional.ofNullable(this.getIssuer()).ifPresent(builder::setIssuer);
            Optional.ofNullable(this.getTradeId()).ifPresent(builder::setTradeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerTradeIdModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            return Objects.equals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerTradeIdModel {issuer=" + this.issuer + ", tradeId=" + this.tradeId + '}';
        }
    }
}

