/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.ExchangeIdentifierModel;
import fpml.confirmation.ExchangeTradedCalculatedPrice;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.ProductReference;
import fpml.confirmation.meta.ExchangeTradedFundMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeTradedFund", builder=ExchangeTradedFundBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ExchangeTradedFund", model="fpml", builder=ExchangeTradedFundBuilderImpl.class, version="0.17.2")
public interface ExchangeTradedFund
extends ExchangeTradedCalculatedPrice {
    public static final ExchangeTradedFundMeta metaData = new ExchangeTradedFundMeta();

    public String getFundManager();

    @Override
    public ExchangeTradedFund build();

    @Override
    public ExchangeTradedFundBuilder toBuilder();

    public static ExchangeTradedFundBuilder builder() {
        return new ExchangeTradedFundBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTradedFund> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTradedFund> getType() {
        return ExchangeTradedFund.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("constituentExchangeId"), processor, ExchangeId.class, this.getConstituentExchangeId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundManager"), String.class, (Object)this.getFundManager(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExchangeTradedFundBuilderImpl
    extends ExchangeTradedCalculatedPrice.ExchangeTradedCalculatedPriceBuilderImpl
    implements ExchangeTradedFundBuilder {
        protected String fundManager;

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public String getFundManager() {
            return this.fundManager;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExchangeTradedFundBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public ExchangeTradedFundBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ExchangeTradedFundBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedFundBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedFundBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ExchangeTradedFundBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ExchangeTradedFundBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeTradedFundBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ExchangeTradedFundBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ExchangeTradedFundBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeTradedFundBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="constituentExchangeId")
        @RuneAttribute(value="constituentExchangeId")
        public ExchangeTradedFundBuilder addConstituentExchangeId(ExchangeId _constituentExchangeId) {
            if (_constituentExchangeId != null) {
                this.constituentExchangeId.add(_constituentExchangeId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addConstituentExchangeId(ExchangeId _constituentExchangeId, int idx) {
            this.getIndex(this.constituentExchangeId, idx, () -> _constituentExchangeId.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder addConstituentExchangeId(List<? extends ExchangeId> constituentExchangeIds) {
            if (constituentExchangeIds != null) {
                for (ExchangeId exchangeId : constituentExchangeIds) {
                    this.constituentExchangeId.add(exchangeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="constituentExchangeId")
        public ExchangeTradedFundBuilder setConstituentExchangeId(List<? extends ExchangeId> constituentExchangeIds) {
            this.constituentExchangeId = constituentExchangeIds == null ? new ArrayList() : (List)constituentExchangeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public ExchangeTradedFundBuilder setFundManager(String _fundManager) {
            this.fundManager = _fundManager == null ? null : _fundManager;
            return this;
        }

        @Override
        public ExchangeTradedFund build() {
            return new ExchangeTradedFundImpl(this);
        }

        @Override
        public ExchangeTradedFundBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFundManager() != null;
        }

        @Override
        public ExchangeTradedFundBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExchangeTradedFundBuilder o = (ExchangeTradedFundBuilder)other;
            merger.mergeBasic((Object)this.getFundManager(), (Object)o.getFundManager(), this::setFundManager, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedFund _that = (ExchangeTradedFund)this.getType().cast(o);
            return Objects.equals(this.fundManager, _that.getFundManager());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fundManager != null ? this.fundManager.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedFundBuilder {fundManager=" + this.fundManager + '}' + " " + super.toString();
        }
    }

    public static interface ExchangeTradedFundBuilder
    extends ExchangeTradedFund,
    ExchangeTradedCalculatedPrice.ExchangeTradedCalculatedPriceBuilder {
        @Override
        public ExchangeTradedFundBuilder setId(String var1);

        @Override
        public ExchangeTradedFundBuilder addInstrumentId(InstrumentId var1);

        @Override
        public ExchangeTradedFundBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public ExchangeTradedFundBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedFundBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedFundBuilder addInstrumentType(InstrumentType var1);

        @Override
        public ExchangeTradedFundBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public ExchangeTradedFundBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedFundBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedFundBuilder setDescription(String var1);

        @Override
        public ExchangeTradedFundBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public ExchangeTradedFundBuilder setExchangeId(ExchangeId var1);

        @Override
        public ExchangeTradedFundBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public ExchangeTradedFundBuilder setDefinition(ProductReference var1);

        @Override
        public ExchangeTradedFundBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        public ExchangeTradedFundBuilder addConstituentExchangeId(ExchangeId var1);

        @Override
        public ExchangeTradedFundBuilder addConstituentExchangeId(ExchangeId var1, int var2);

        @Override
        public ExchangeTradedFundBuilder addConstituentExchangeId(List<? extends ExchangeId> var1);

        @Override
        public ExchangeTradedFundBuilder setConstituentExchangeId(List<? extends ExchangeId> var1);

        public ExchangeTradedFundBuilder setFundManager(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("constituentExchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getConstituentExchangeId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundManager"), String.class, (Object)this.getFundManager(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ExchangeTradedFundBuilder prune();
    }

    public static class ExchangeTradedFundImpl
    extends ExchangeTradedCalculatedPrice.ExchangeTradedCalculatedPriceImpl
    implements ExchangeTradedFund {
        private final String fundManager;

        protected ExchangeTradedFundImpl(ExchangeTradedFundBuilder builder) {
            super(builder);
            this.fundManager = builder.getFundManager();
        }

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public String getFundManager() {
            return this.fundManager;
        }

        @Override
        public ExchangeTradedFund build() {
            return this;
        }

        @Override
        public ExchangeTradedFundBuilder toBuilder() {
            ExchangeTradedFundBuilder builder = ExchangeTradedFund.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedFundBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFundManager()).ifPresent(builder::setFundManager);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedFund _that = (ExchangeTradedFund)this.getType().cast(o);
            return Objects.equals(this.fundManager, _that.getFundManager());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fundManager != null ? this.fundManager.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedFund {fundManager=" + this.fundManager + '}' + " " + super.toString();
        }
    }
}

