/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Asset;
import fpml.confirmation.FloatingRateIndexModel;
import fpml.confirmation.QuotedCurrencyPair;
import fpml.confirmation.meta.ExchangeTradedContractUnderlyerMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeTradedContractUnderlyer", builder=ExchangeTradedContractUnderlyerBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ExchangeTradedContractUnderlyer", model="fpml", builder=ExchangeTradedContractUnderlyerBuilderImpl.class, version="0.17.2")
public interface ExchangeTradedContractUnderlyer
extends RosettaModelObject {
    public static final ExchangeTradedContractUnderlyerMeta metaData = new ExchangeTradedContractUnderlyerMeta();

    public FloatingRateIndexModel getFloatingRateIndexModel();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public List<? extends Asset> getUnderlyingAsset();

    public ExchangeTradedContractUnderlyer build();

    public ExchangeTradedContractUnderlyerBuilder toBuilder();

    public static ExchangeTradedContractUnderlyerBuilder builder() {
        return new ExchangeTradedContractUnderlyerBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTradedContractUnderlyer> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTradedContractUnderlyer> getType() {
        return ExchangeTradedContractUnderlyer.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.class, this.getFloatingRateIndexModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
    }

    public static class ExchangeTradedContractUnderlyerBuilderImpl
    implements ExchangeTradedContractUnderlyerBuilder {
        protected FloatingRateIndexModel.FloatingRateIndexModelBuilder floatingRateIndexModel;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected List<Asset.AssetBuilder> underlyingAsset = new ArrayList<Asset.AssetBuilder>();

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getFloatingRateIndexModel() {
            return this.floatingRateIndexModel;
        }

        @Override
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getOrCreateFloatingRateIndexModel() {
            FloatingRateIndexModel.FloatingRateIndexModelBuilder result = this.floatingRateIndexModel != null ? this.floatingRateIndexModel : (this.floatingRateIndexModel = FloatingRateIndexModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public List<? extends Asset.AssetBuilder> getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset(int index) {
            if (this.underlyingAsset == null) {
                this.underlyingAsset = new ArrayList<Asset.AssetBuilder>();
            }
            return (Asset.AssetBuilder)this.getIndex(this.underlyingAsset, index, () -> {
                Asset.AssetBuilder newUnderlyingAsset = Asset.builder();
                return newUnderlyingAsset;
            });
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public ExchangeTradedContractUnderlyerBuilder setFloatingRateIndexModel(FloatingRateIndexModel _floatingRateIndexModel) {
            this.floatingRateIndexModel = _floatingRateIndexModel == null ? null : _floatingRateIndexModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public ExchangeTradedContractUnderlyerBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(Asset _underlyingAsset) {
            if (_underlyingAsset != null) {
                this.underlyingAsset.add(_underlyingAsset.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(Asset _underlyingAsset, int idx) {
            this.getIndex(this.underlyingAsset, idx, () -> _underlyingAsset.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(List<? extends Asset> underlyingAssets) {
            if (underlyingAssets != null) {
                for (Asset asset : underlyingAssets) {
                    this.underlyingAsset.add(asset.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyingAsset")
        public ExchangeTradedContractUnderlyerBuilder setUnderlyingAsset(List<? extends Asset> underlyingAssets) {
            this.underlyingAsset = underlyingAssets == null ? new ArrayList<Asset.AssetBuilder>() : (List)underlyingAssets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExchangeTradedContractUnderlyer build() {
            return new ExchangeTradedContractUnderlyerImpl(this);
        }

        @Override
        public ExchangeTradedContractUnderlyerBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedContractUnderlyerBuilder prune() {
            if (this.floatingRateIndexModel != null && !this.floatingRateIndexModel.prune().hasData()) {
                this.floatingRateIndexModel = null;
            }
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            this.underlyingAsset = this.underlyingAsset.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRateIndexModel() != null && this.getFloatingRateIndexModel().hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            return this.getUnderlyingAsset() != null && this.getUnderlyingAsset().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ExchangeTradedContractUnderlyerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExchangeTradedContractUnderlyerBuilder o = (ExchangeTradedContractUnderlyerBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndexModel(), (RosettaModelObjectBuilder)o.getFloatingRateIndexModel(), this::setFloatingRateIndexModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta(this.getUnderlyingAsset(), o.getUnderlyingAsset(), this::getOrCreateUnderlyingAsset);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeTradedContractUnderlyer _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndexModel, _that.getFloatingRateIndexModel())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            return ListEquals.listEquals(this.underlyingAsset, _that.getUnderlyingAsset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndexModel != null ? this.floatingRateIndexModel.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeTradedContractUnderlyerBuilder {floatingRateIndexModel=" + this.floatingRateIndexModel + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", underlyingAsset=" + this.underlyingAsset + '}';
        }
    }

    public static interface ExchangeTradedContractUnderlyerBuilder
    extends ExchangeTradedContractUnderlyer,
    RosettaModelObjectBuilder {
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getOrCreateFloatingRateIndexModel();

        @Override
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getFloatingRateIndexModel();

        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public Asset.AssetBuilder getOrCreateUnderlyingAsset(int var1);

        public List<? extends Asset.AssetBuilder> getUnderlyingAsset();

        public ExchangeTradedContractUnderlyerBuilder setFloatingRateIndexModel(FloatingRateIndexModel var1);

        public ExchangeTradedContractUnderlyerBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(Asset var1);

        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(Asset var1, int var2);

        public ExchangeTradedContractUnderlyerBuilder addUnderlyingAsset(List<? extends Asset> var1);

        public ExchangeTradedContractUnderlyerBuilder setUnderlyingAsset(List<? extends Asset> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.FloatingRateIndexModelBuilder.class, this.getFloatingRateIndexModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        }

        public ExchangeTradedContractUnderlyerBuilder prune();
    }

    public static class ExchangeTradedContractUnderlyerImpl
    implements ExchangeTradedContractUnderlyer {
        private final FloatingRateIndexModel floatingRateIndexModel;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final List<? extends Asset> underlyingAsset;

        protected ExchangeTradedContractUnderlyerImpl(ExchangeTradedContractUnderlyerBuilder builder) {
            this.floatingRateIndexModel = Optional.ofNullable(builder.getFloatingRateIndexModel()).map(f -> f.build()).orElse(null);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public FloatingRateIndexModel getFloatingRateIndexModel() {
            return this.floatingRateIndexModel;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public List<? extends Asset> getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public ExchangeTradedContractUnderlyer build() {
            return this;
        }

        @Override
        public ExchangeTradedContractUnderlyerBuilder toBuilder() {
            ExchangeTradedContractUnderlyerBuilder builder = ExchangeTradedContractUnderlyer.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedContractUnderlyerBuilder builder) {
            Optional.ofNullable(this.getFloatingRateIndexModel()).ifPresent(builder::setFloatingRateIndexModel);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeTradedContractUnderlyer _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndexModel, _that.getFloatingRateIndexModel())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            return ListEquals.listEquals(this.underlyingAsset, _that.getUnderlyingAsset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndexModel != null ? this.floatingRateIndexModel.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeTradedContractUnderlyer {floatingRateIndexModel=" + this.floatingRateIndexModel + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", underlyingAsset=" + this.underlyingAsset + '}';
        }
    }
}

