/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.Leg;
import fpml.confirmation.LegIdentifier;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.meta.DirectionalLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DirectionalLeg", builder=DirectionalLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DirectionalLeg", model="fpml", builder=DirectionalLegBuilderImpl.class, version="0.17.2")
public interface DirectionalLeg
extends Leg {
    public static final DirectionalLegMeta metaData = new DirectionalLegMeta();

    public List<? extends LegIdentifier> getLegIdentifier();

    public PayerReceiverModel getPayerReceiverModel();

    public AdjustableOrRelativeDate getEffectiveDate();

    public AdjustableOrRelativeDate getTerminationDate();

    @Override
    public DirectionalLeg build();

    @Override
    public DirectionalLegBuilder toBuilder();

    public static DirectionalLegBuilder builder() {
        return new DirectionalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends DirectionalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DirectionalLeg> getType() {
        return DirectionalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
    }

    public static class DirectionalLegBuilderImpl
    extends Leg.LegBuilderImpl
    implements DirectionalLegBuilder {
        protected List<LegIdentifier.LegIdentifierBuilder> legIdentifier = new ArrayList<LegIdentifier.LegIdentifierBuilder>();
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder terminationDate;

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public List<? extends LegIdentifier.LegIdentifierBuilder> getLegIdentifier() {
            return this.legIdentifier;
        }

        @Override
        public LegIdentifier.LegIdentifierBuilder getOrCreateLegIdentifier(int index) {
            if (this.legIdentifier == null) {
                this.legIdentifier = new ArrayList<LegIdentifier.LegIdentifierBuilder>();
            }
            return (LegIdentifier.LegIdentifierBuilder)this.getIndex(this.legIdentifier, index, () -> {
                LegIdentifier.LegIdentifierBuilder newLegIdentifier = LegIdentifier.builder();
                return newLegIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.terminationDate != null ? this.terminationDate : (this.terminationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DirectionalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public DirectionalLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public DirectionalLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public DirectionalLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public DirectionalLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList<LegIdentifier.LegIdentifierBuilder>() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public DirectionalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public DirectionalLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public DirectionalLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        public DirectionalLeg build() {
            return new DirectionalLegImpl(this);
        }

        @Override
        public DirectionalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public DirectionalLegBuilder prune() {
            super.prune();
            this.legIdentifier = this.legIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.terminationDate != null && !this.terminationDate.prune().hasData()) {
                this.terminationDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLegIdentifier() != null && this.getLegIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            return this.getTerminationDate() != null && this.getTerminationDate().hasData();
        }

        @Override
        public DirectionalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DirectionalLegBuilder o = (DirectionalLegBuilder)other;
            merger.mergeRosetta(this.getLegIdentifier(), o.getLegIdentifier(), this::getOrCreateLegIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationDate(), (RosettaModelObjectBuilder)o.getTerminationDate(), this::setTerminationDate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DirectionalLeg _that = (DirectionalLeg)this.getType().cast(o);
            if (!ListEquals.listEquals(this.legIdentifier, _that.getLegIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.terminationDate, _that.getTerminationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.legIdentifier != null ? this.legIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DirectionalLegBuilder {legIdentifier=" + this.legIdentifier + ", payerReceiverModel=" + this.payerReceiverModel + ", effectiveDate=" + this.effectiveDate + ", terminationDate=" + this.terminationDate + '}' + " " + super.toString();
        }
    }

    public static interface DirectionalLegBuilder
    extends DirectionalLeg,
    Leg.LegBuilder {
        public LegIdentifier.LegIdentifierBuilder getOrCreateLegIdentifier(int var1);

        public List<? extends LegIdentifier.LegIdentifierBuilder> getLegIdentifier();

        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate();

        @Override
        public DirectionalLegBuilder setId(String var1);

        public DirectionalLegBuilder addLegIdentifier(LegIdentifier var1);

        public DirectionalLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        public DirectionalLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        public DirectionalLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        public DirectionalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public DirectionalLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public DirectionalLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getTerminationDate(), new AttributeMeta[0]);
        }

        @Override
        public DirectionalLegBuilder prune();
    }

    public static class DirectionalLegImpl
    extends Leg.LegImpl
    implements DirectionalLeg {
        private final List<? extends LegIdentifier> legIdentifier;
        private final PayerReceiverModel payerReceiverModel;
        private final AdjustableOrRelativeDate effectiveDate;
        private final AdjustableOrRelativeDate terminationDate;

        protected DirectionalLegImpl(DirectionalLegBuilder builder) {
            super(builder);
            this.legIdentifier = Optional.ofNullable(builder.getLegIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.terminationDate = Optional.ofNullable(builder.getTerminationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public List<? extends LegIdentifier> getLegIdentifier() {
            return this.legIdentifier;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableOrRelativeDate getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public DirectionalLeg build() {
            return this;
        }

        @Override
        public DirectionalLegBuilder toBuilder() {
            DirectionalLegBuilder builder = DirectionalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DirectionalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLegIdentifier()).ifPresent(builder::setLegIdentifier);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getTerminationDate()).ifPresent(builder::setTerminationDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DirectionalLeg _that = (DirectionalLeg)this.getType().cast(o);
            if (!ListEquals.listEquals(this.legIdentifier, _that.getLegIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.terminationDate, _that.getTerminationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.legIdentifier != null ? this.legIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DirectionalLeg {legIdentifier=" + this.legIdentifier + ", payerReceiverModel=" + this.payerReceiverModel + ", effectiveDate=" + this.effectiveDate + ", terminationDate=" + this.terminationDate + '}' + " " + super.toString();
        }
    }
}

