/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CashSettlementReferenceBanks;
import fpml.confirmation.Currency;
import fpml.confirmation.QuotationRateTypeEnum;
import fpml.confirmation.meta.CrossCurrencyMethodMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CrossCurrencyMethod", builder=CrossCurrencyMethodBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CrossCurrencyMethod", model="fpml", builder=CrossCurrencyMethodBuilderImpl.class, version="0.17.2")
public interface CrossCurrencyMethod
extends RosettaModelObject {
    public static final CrossCurrencyMethodMeta metaData = new CrossCurrencyMethodMeta();

    public CashSettlementReferenceBanks getCashSettlementReferenceBanks();

    public List<? extends Currency> getCashSettlementCurrency();

    public QuotationRateTypeEnum getQuotationRateType();

    public CrossCurrencyMethod build();

    public CrossCurrencyMethodBuilder toBuilder();

    public static CrossCurrencyMethodBuilder builder() {
        return new CrossCurrencyMethodBuilderImpl();
    }

    default public RosettaMetaData<? extends CrossCurrencyMethod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CrossCurrencyMethod> getType() {
        return CrossCurrencyMethod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("cashSettlementReferenceBanks"), processor, CashSettlementReferenceBanks.class, this.getCashSettlementReferenceBanks(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlementCurrency"), processor, Currency.class, this.getCashSettlementCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quotationRateType"), QuotationRateTypeEnum.class, (Object)this.getQuotationRateType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CrossCurrencyMethodBuilderImpl
    implements CrossCurrencyMethodBuilder {
        protected CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder cashSettlementReferenceBanks;
        protected List<Currency.CurrencyBuilder> cashSettlementCurrency = new ArrayList<Currency.CurrencyBuilder>();
        protected QuotationRateTypeEnum quotationRateType;

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getCashSettlementReferenceBanks() {
            return this.cashSettlementReferenceBanks;
        }

        @Override
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getOrCreateCashSettlementReferenceBanks() {
            CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder result = this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks : (this.cashSettlementReferenceBanks = CashSettlementReferenceBanks.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlementCurrency", isRequired=true)
        @RuneAttribute(value="cashSettlementCurrency", isRequired=true)
        public List<? extends Currency.CurrencyBuilder> getCashSettlementCurrency() {
            return this.cashSettlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCashSettlementCurrency(int index) {
            if (this.cashSettlementCurrency == null) {
                this.cashSettlementCurrency = new ArrayList<Currency.CurrencyBuilder>();
            }
            return (Currency.CurrencyBuilder)this.getIndex(this.cashSettlementCurrency, index, () -> {
                Currency.CurrencyBuilder newCashSettlementCurrency = Currency.builder();
                return newCashSettlementCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="quotationRateType", isRequired=true)
        @RuneAttribute(value="quotationRateType", isRequired=true)
        public QuotationRateTypeEnum getQuotationRateType() {
            return this.quotationRateType;
        }

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public CrossCurrencyMethodBuilder setCashSettlementReferenceBanks(CashSettlementReferenceBanks _cashSettlementReferenceBanks) {
            this.cashSettlementReferenceBanks = _cashSettlementReferenceBanks == null ? null : _cashSettlementReferenceBanks.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlementCurrency", isRequired=true)
        @RuneAttribute(value="cashSettlementCurrency", isRequired=true)
        public CrossCurrencyMethodBuilder addCashSettlementCurrency(Currency _cashSettlementCurrency) {
            if (_cashSettlementCurrency != null) {
                this.cashSettlementCurrency.add(_cashSettlementCurrency.toBuilder());
            }
            return this;
        }

        @Override
        public CrossCurrencyMethodBuilder addCashSettlementCurrency(Currency _cashSettlementCurrency, int idx) {
            this.getIndex(this.cashSettlementCurrency, idx, () -> _cashSettlementCurrency.toBuilder());
            return this;
        }

        @Override
        public CrossCurrencyMethodBuilder addCashSettlementCurrency(List<? extends Currency> cashSettlementCurrencys) {
            if (cashSettlementCurrencys != null) {
                for (Currency currency : cashSettlementCurrencys) {
                    this.cashSettlementCurrency.add(currency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="cashSettlementCurrency")
        public CrossCurrencyMethodBuilder setCashSettlementCurrency(List<? extends Currency> cashSettlementCurrencys) {
            this.cashSettlementCurrency = cashSettlementCurrencys == null ? new ArrayList<Currency.CurrencyBuilder>() : (List)cashSettlementCurrencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationRateType", isRequired=true)
        @RuneAttribute(value="quotationRateType", isRequired=true)
        public CrossCurrencyMethodBuilder setQuotationRateType(QuotationRateTypeEnum _quotationRateType) {
            this.quotationRateType = _quotationRateType == null ? null : _quotationRateType;
            return this;
        }

        @Override
        public CrossCurrencyMethod build() {
            return new CrossCurrencyMethodImpl(this);
        }

        @Override
        public CrossCurrencyMethodBuilder toBuilder() {
            return this;
        }

        @Override
        public CrossCurrencyMethodBuilder prune() {
            if (this.cashSettlementReferenceBanks != null && !this.cashSettlementReferenceBanks.prune().hasData()) {
                this.cashSettlementReferenceBanks = null;
            }
            this.cashSettlementCurrency = this.cashSettlementCurrency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCashSettlementReferenceBanks() != null && this.getCashSettlementReferenceBanks().hasData()) {
                return true;
            }
            if (this.getCashSettlementCurrency() != null && this.getCashSettlementCurrency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getQuotationRateType() != null;
        }

        public CrossCurrencyMethodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CrossCurrencyMethodBuilder o = (CrossCurrencyMethodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlementReferenceBanks(), (RosettaModelObjectBuilder)o.getCashSettlementReferenceBanks(), this::setCashSettlementReferenceBanks);
            merger.mergeRosetta(this.getCashSettlementCurrency(), o.getCashSettlementCurrency(), this::getOrCreateCashSettlementCurrency);
            merger.mergeBasic((Object)this.getQuotationRateType(), (Object)o.getQuotationRateType(), this::setQuotationRateType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CrossCurrencyMethod _that = this.getType().cast(o);
            if (!Objects.equals(this.cashSettlementReferenceBanks, _that.getCashSettlementReferenceBanks())) {
                return false;
            }
            if (!ListEquals.listEquals(this.cashSettlementCurrency, _that.getCashSettlementCurrency())) {
                return false;
            }
            return Objects.equals((Object)this.quotationRateType, (Object)_that.getQuotationRateType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementCurrency != null ? this.cashSettlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.quotationRateType != null ? ((Object)((Object)this.quotationRateType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CrossCurrencyMethodBuilder {cashSettlementReferenceBanks=" + this.cashSettlementReferenceBanks + ", cashSettlementCurrency=" + this.cashSettlementCurrency + ", quotationRateType=" + (Object)((Object)this.quotationRateType) + '}';
        }
    }

    public static interface CrossCurrencyMethodBuilder
    extends CrossCurrencyMethod,
    RosettaModelObjectBuilder {
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getOrCreateCashSettlementReferenceBanks();

        @Override
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getCashSettlementReferenceBanks();

        public Currency.CurrencyBuilder getOrCreateCashSettlementCurrency(int var1);

        public List<? extends Currency.CurrencyBuilder> getCashSettlementCurrency();

        public CrossCurrencyMethodBuilder setCashSettlementReferenceBanks(CashSettlementReferenceBanks var1);

        public CrossCurrencyMethodBuilder addCashSettlementCurrency(Currency var1);

        public CrossCurrencyMethodBuilder addCashSettlementCurrency(Currency var1, int var2);

        public CrossCurrencyMethodBuilder addCashSettlementCurrency(List<? extends Currency> var1);

        public CrossCurrencyMethodBuilder setCashSettlementCurrency(List<? extends Currency> var1);

        public CrossCurrencyMethodBuilder setQuotationRateType(QuotationRateTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("cashSettlementReferenceBanks"), processor, CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder.class, this.getCashSettlementReferenceBanks(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getCashSettlementCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quotationRateType"), QuotationRateTypeEnum.class, (Object)this.getQuotationRateType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CrossCurrencyMethodBuilder prune();
    }

    public static class CrossCurrencyMethodImpl
    implements CrossCurrencyMethod {
        private final CashSettlementReferenceBanks cashSettlementReferenceBanks;
        private final List<? extends Currency> cashSettlementCurrency;
        private final QuotationRateTypeEnum quotationRateType;

        protected CrossCurrencyMethodImpl(CrossCurrencyMethodBuilder builder) {
            this.cashSettlementReferenceBanks = Optional.ofNullable(builder.getCashSettlementReferenceBanks()).map(f -> f.build()).orElse(null);
            this.cashSettlementCurrency = Optional.ofNullable(builder.getCashSettlementCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.quotationRateType = builder.getQuotationRateType();
        }

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public CashSettlementReferenceBanks getCashSettlementReferenceBanks() {
            return this.cashSettlementReferenceBanks;
        }

        @Override
        @RosettaAttribute(value="cashSettlementCurrency", isRequired=true)
        @RuneAttribute(value="cashSettlementCurrency", isRequired=true)
        public List<? extends Currency> getCashSettlementCurrency() {
            return this.cashSettlementCurrency;
        }

        @Override
        @RosettaAttribute(value="quotationRateType", isRequired=true)
        @RuneAttribute(value="quotationRateType", isRequired=true)
        public QuotationRateTypeEnum getQuotationRateType() {
            return this.quotationRateType;
        }

        @Override
        public CrossCurrencyMethod build() {
            return this;
        }

        @Override
        public CrossCurrencyMethodBuilder toBuilder() {
            CrossCurrencyMethodBuilder builder = CrossCurrencyMethod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CrossCurrencyMethodBuilder builder) {
            Optional.ofNullable(this.getCashSettlementReferenceBanks()).ifPresent(builder::setCashSettlementReferenceBanks);
            Optional.ofNullable(this.getCashSettlementCurrency()).ifPresent(builder::setCashSettlementCurrency);
            Optional.ofNullable(this.getQuotationRateType()).ifPresent(builder::setQuotationRateType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CrossCurrencyMethod _that = this.getType().cast(o);
            if (!Objects.equals(this.cashSettlementReferenceBanks, _that.getCashSettlementReferenceBanks())) {
                return false;
            }
            if (!ListEquals.listEquals(this.cashSettlementCurrency, _that.getCashSettlementCurrency())) {
                return false;
            }
            return Objects.equals((Object)this.quotationRateType, (Object)_that.getQuotationRateType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementCurrency != null ? this.cashSettlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.quotationRateType != null ? ((Object)((Object)this.quotationRateType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CrossCurrencyMethod {cashSettlementReferenceBanks=" + this.cashSettlementReferenceBanks + ", cashSettlementCurrency=" + this.cashSettlementCurrency + ", quotationRateType=" + (Object)((Object)this.quotationRateType) + '}';
        }
    }
}

