/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ContractId;
import fpml.confirmation.PartyReference;
import fpml.confirmation.VersionedContractId;
import fpml.confirmation.meta.ContractIdentifierMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ContractIdentifier", builder=ContractIdentifierBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ContractIdentifier", model="fpml", builder=ContractIdentifierBuilderImpl.class, version="0.17.2")
public interface ContractIdentifier
extends RosettaModelObject {
    public static final ContractIdentifierMeta metaData = new ContractIdentifierMeta();

    public PartyReference getPartyReference();

    public List<? extends ContractId> getContractId();

    public List<? extends VersionedContractId> getVersionedContractId();

    public String getId();

    public ContractIdentifier build();

    public ContractIdentifierBuilder toBuilder();

    public static ContractIdentifierBuilder builder() {
        return new ContractIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends ContractIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ContractIdentifier> getType() {
        return ContractIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractId"), processor, ContractId.class, this.getContractId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.class, this.getVersionedContractId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ContractIdentifierBuilderImpl
    implements ContractIdentifierBuilder {
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<ContractId.ContractIdBuilder> contractId = new ArrayList<ContractId.ContractIdBuilder>();
        protected List<VersionedContractId.VersionedContractIdBuilder> versionedContractId = new ArrayList<VersionedContractId.VersionedContractIdBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public List<? extends ContractId.ContractIdBuilder> getContractId() {
            return this.contractId;
        }

        @Override
        public ContractId.ContractIdBuilder getOrCreateContractId(int index) {
            if (this.contractId == null) {
                this.contractId = new ArrayList<ContractId.ContractIdBuilder>();
            }
            return (ContractId.ContractIdBuilder)this.getIndex(this.contractId, index, () -> {
                ContractId.ContractIdBuilder newContractId = ContractId.builder();
                return newContractId;
            });
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public List<? extends VersionedContractId.VersionedContractIdBuilder> getVersionedContractId() {
            return this.versionedContractId;
        }

        @Override
        public VersionedContractId.VersionedContractIdBuilder getOrCreateVersionedContractId(int index) {
            if (this.versionedContractId == null) {
                this.versionedContractId = new ArrayList<VersionedContractId.VersionedContractIdBuilder>();
            }
            return (VersionedContractId.VersionedContractIdBuilder)this.getIndex(this.versionedContractId, index, () -> {
                VersionedContractId.VersionedContractIdBuilder newVersionedContractId = VersionedContractId.builder();
                return newVersionedContractId;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public ContractIdentifierBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public ContractIdentifierBuilder addContractId(ContractId _contractId) {
            if (_contractId != null) {
                this.contractId.add(_contractId.toBuilder());
            }
            return this;
        }

        @Override
        public ContractIdentifierBuilder addContractId(ContractId _contractId, int idx) {
            this.getIndex(this.contractId, idx, () -> _contractId.toBuilder());
            return this;
        }

        @Override
        public ContractIdentifierBuilder addContractId(List<? extends ContractId> contractIds) {
            if (contractIds != null) {
                for (ContractId contractId : contractIds) {
                    this.contractId.add(contractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractId")
        public ContractIdentifierBuilder setContractId(List<? extends ContractId> contractIds) {
            this.contractId = contractIds == null ? new ArrayList<ContractId.ContractIdBuilder>() : (List)contractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public ContractIdentifierBuilder addVersionedContractId(VersionedContractId _versionedContractId) {
            if (_versionedContractId != null) {
                this.versionedContractId.add(_versionedContractId.toBuilder());
            }
            return this;
        }

        @Override
        public ContractIdentifierBuilder addVersionedContractId(VersionedContractId _versionedContractId, int idx) {
            this.getIndex(this.versionedContractId, idx, () -> _versionedContractId.toBuilder());
            return this;
        }

        @Override
        public ContractIdentifierBuilder addVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            if (versionedContractIds != null) {
                for (VersionedContractId versionedContractId : versionedContractIds) {
                    this.versionedContractId.add(versionedContractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedContractId")
        public ContractIdentifierBuilder setVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            this.versionedContractId = versionedContractIds == null ? new ArrayList<VersionedContractId.VersionedContractIdBuilder>() : (List)versionedContractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ContractIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ContractIdentifier build() {
            return new ContractIdentifierImpl(this);
        }

        @Override
        public ContractIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public ContractIdentifierBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.contractId = this.contractId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.versionedContractId = this.versionedContractId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getContractId() != null && this.getContractId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getVersionedContractId() != null && this.getVersionedContractId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public ContractIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ContractIdentifierBuilder o = (ContractIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getContractId(), o.getContractId(), this::getOrCreateContractId);
            merger.mergeRosetta(this.getVersionedContractId(), o.getVersionedContractId(), this::getOrCreateVersionedContractId);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractId, _that.getContractId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedContractId, _that.getVersionedContractId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.contractId != null ? this.contractId.hashCode() : 0);
            _result = 31 * _result + (this.versionedContractId != null ? this.versionedContractId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractIdentifierBuilder {partyReference=" + this.partyReference + ", contractId=" + this.contractId + ", versionedContractId=" + this.versionedContractId + ", id=" + this.id + '}';
        }
    }

    public static interface ContractIdentifierBuilder
    extends ContractIdentifier,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public ContractId.ContractIdBuilder getOrCreateContractId(int var1);

        public List<? extends ContractId.ContractIdBuilder> getContractId();

        public VersionedContractId.VersionedContractIdBuilder getOrCreateVersionedContractId(int var1);

        public List<? extends VersionedContractId.VersionedContractIdBuilder> getVersionedContractId();

        public ContractIdentifierBuilder setPartyReference(PartyReference var1);

        public ContractIdentifierBuilder addContractId(ContractId var1);

        public ContractIdentifierBuilder addContractId(ContractId var1, int var2);

        public ContractIdentifierBuilder addContractId(List<? extends ContractId> var1);

        public ContractIdentifierBuilder setContractId(List<? extends ContractId> var1);

        public ContractIdentifierBuilder addVersionedContractId(VersionedContractId var1);

        public ContractIdentifierBuilder addVersionedContractId(VersionedContractId var1, int var2);

        public ContractIdentifierBuilder addVersionedContractId(List<? extends VersionedContractId> var1);

        public ContractIdentifierBuilder setVersionedContractId(List<? extends VersionedContractId> var1);

        public ContractIdentifierBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractId"), processor, ContractId.ContractIdBuilder.class, this.getContractId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.VersionedContractIdBuilder.class, this.getVersionedContractId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ContractIdentifierBuilder prune();
    }

    public static class ContractIdentifierImpl
    implements ContractIdentifier {
        private final PartyReference partyReference;
        private final List<? extends ContractId> contractId;
        private final List<? extends VersionedContractId> versionedContractId;
        private final String id;

        protected ContractIdentifierImpl(ContractIdentifierBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.contractId = Optional.ofNullable(builder.getContractId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.versionedContractId = Optional.ofNullable(builder.getVersionedContractId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public List<? extends ContractId> getContractId() {
            return this.contractId;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public List<? extends VersionedContractId> getVersionedContractId() {
            return this.versionedContractId;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ContractIdentifier build() {
            return this;
        }

        @Override
        public ContractIdentifierBuilder toBuilder() {
            ContractIdentifierBuilder builder = ContractIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ContractIdentifierBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getContractId()).ifPresent(builder::setContractId);
            Optional.ofNullable(this.getVersionedContractId()).ifPresent(builder::setVersionedContractId);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractId, _that.getContractId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedContractId, _that.getVersionedContractId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.contractId != null ? this.contractId.hashCode() : 0);
            _result = 31 * _result + (this.versionedContractId != null ? this.versionedContractId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractIdentifier {partyReference=" + this.partyReference + ", contractId=" + this.contractId + ", versionedContractId=" + this.versionedContractId + ", id=" + this.id + '}';
        }
    }
}

