/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Reason;
import fpml.confirmation.SupervisoryBody;
import fpml.confirmation.meta.ClearingRequirementsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingRequirements", builder=ClearingRequirementsBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ClearingRequirements", model="fpml", builder=ClearingRequirementsBuilderImpl.class, version="0.17.2")
public interface ClearingRequirements
extends RosettaModelObject {
    public static final ClearingRequirementsMeta metaData = new ClearingRequirementsMeta();

    public SupervisoryBody getSupervisoryBody();

    public Boolean getMandatorilyClearable();

    public List<? extends Reason> getReason();

    public ClearingRequirements build();

    public ClearingRequirementsBuilder toBuilder();

    public static ClearingRequirementsBuilder builder() {
        return new ClearingRequirementsBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingRequirements> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingRequirements> getType() {
        return ClearingRequirements.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("supervisoryBody"), processor, SupervisoryBody.class, this.getSupervisoryBody(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mandatorilyClearable"), Boolean.class, (Object)this.getMandatorilyClearable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class ClearingRequirementsBuilderImpl
    implements ClearingRequirementsBuilder {
        protected SupervisoryBody.SupervisoryBodyBuilder supervisoryBody;
        protected Boolean mandatorilyClearable;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public SupervisoryBody.SupervisoryBodyBuilder getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        public SupervisoryBody.SupervisoryBodyBuilder getOrCreateSupervisoryBody() {
            SupervisoryBody.SupervisoryBodyBuilder result = this.supervisoryBody != null ? this.supervisoryBody : (this.supervisoryBody = SupervisoryBody.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable", isRequired=true)
        @RuneAttribute(value="mandatorilyClearable", isRequired=true)
        public Boolean getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public ClearingRequirementsBuilder setSupervisoryBody(SupervisoryBody _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable", isRequired=true)
        @RuneAttribute(value="mandatorilyClearable", isRequired=true)
        public ClearingRequirementsBuilder setMandatorilyClearable(Boolean _mandatorilyClearable) {
            this.mandatorilyClearable = _mandatorilyClearable == null ? null : _mandatorilyClearable;
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ClearingRequirementsBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingRequirementsBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ClearingRequirementsBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ClearingRequirementsBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ClearingRequirements build() {
            return new ClearingRequirementsImpl(this);
        }

        @Override
        public ClearingRequirementsBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingRequirementsBuilder prune() {
            if (this.supervisoryBody != null && !this.supervisoryBody.prune().hasData()) {
                this.supervisoryBody = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSupervisoryBody() != null && this.getSupervisoryBody().hasData()) {
                return true;
            }
            if (this.getMandatorilyClearable() != null) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ClearingRequirementsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ClearingRequirementsBuilder o = (ClearingRequirementsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSupervisoryBody(), (RosettaModelObjectBuilder)o.getSupervisoryBody(), this::setSupervisoryBody);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            merger.mergeBasic((Object)this.getMandatorilyClearable(), (Object)o.getMandatorilyClearable(), this::setMandatorilyClearable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingRequirements _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingRequirementsBuilder {supervisoryBody=" + this.supervisoryBody + ", mandatorilyClearable=" + this.mandatorilyClearable + ", reason=" + this.reason + '}';
        }
    }

    public static interface ClearingRequirementsBuilder
    extends ClearingRequirements,
    RosettaModelObjectBuilder {
        public SupervisoryBody.SupervisoryBodyBuilder getOrCreateSupervisoryBody();

        @Override
        public SupervisoryBody.SupervisoryBodyBuilder getSupervisoryBody();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        public ClearingRequirementsBuilder setSupervisoryBody(SupervisoryBody var1);

        public ClearingRequirementsBuilder setMandatorilyClearable(Boolean var1);

        public ClearingRequirementsBuilder addReason(Reason var1);

        public ClearingRequirementsBuilder addReason(Reason var1, int var2);

        public ClearingRequirementsBuilder addReason(List<? extends Reason> var1);

        public ClearingRequirementsBuilder setReason(List<? extends Reason> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("supervisoryBody"), processor, SupervisoryBody.SupervisoryBodyBuilder.class, this.getSupervisoryBody(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mandatorilyClearable"), Boolean.class, (Object)this.getMandatorilyClearable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        public ClearingRequirementsBuilder prune();
    }

    public static class ClearingRequirementsImpl
    implements ClearingRequirements {
        private final SupervisoryBody supervisoryBody;
        private final Boolean mandatorilyClearable;
        private final List<? extends Reason> reason;

        protected ClearingRequirementsImpl(ClearingRequirementsBuilder builder) {
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).map(f -> f.build()).orElse(null);
            this.mandatorilyClearable = builder.getMandatorilyClearable();
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public SupervisoryBody getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable", isRequired=true)
        @RuneAttribute(value="mandatorilyClearable", isRequired=true)
        public Boolean getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public ClearingRequirements build() {
            return this;
        }

        @Override
        public ClearingRequirementsBuilder toBuilder() {
            ClearingRequirementsBuilder builder = ClearingRequirements.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingRequirementsBuilder builder) {
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getMandatorilyClearable()).ifPresent(builder::setMandatorilyClearable);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingRequirements _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingRequirements {supervisoryBody=" + this.supervisoryBody + ", mandatorilyClearable=" + this.mandatorilyClearable + ", reason=" + this.reason + '}';
        }
    }
}

