/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AveragingObservationList;
import fpml.confirmation.AveragingSchedule;
import fpml.confirmation.DateTimeList;
import fpml.confirmation.MarketDisruption;
import fpml.confirmation.meta.AveragingPeriodMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AveragingPeriod", builder=AveragingPeriodBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AveragingPeriod", model="fpml", builder=AveragingPeriodBuilderImpl.class, version="0.17.2")
public interface AveragingPeriod
extends RosettaModelObject {
    public static final AveragingPeriodMeta metaData = new AveragingPeriodMeta();

    public List<? extends AveragingSchedule> getSchedule();

    public DateTimeList getAveragingDateTimes();

    public AveragingObservationList getAveragingObservations();

    public MarketDisruption getMarketDisruption();

    public AveragingPeriod build();

    public AveragingPeriodBuilder toBuilder();

    public static AveragingPeriodBuilder builder() {
        return new AveragingPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends AveragingPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AveragingPeriod> getType() {
        return AveragingPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingDateTimes"), processor, DateTimeList.class, this.getAveragingDateTimes(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingObservations"), processor, AveragingObservationList.class, this.getAveragingObservations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marketDisruption"), processor, MarketDisruption.class, this.getMarketDisruption(), new AttributeMeta[0]);
    }

    public static class AveragingPeriodBuilderImpl
    implements AveragingPeriodBuilder {
        protected List<AveragingSchedule.AveragingScheduleBuilder> schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();
        protected DateTimeList.DateTimeListBuilder averagingDateTimes;
        protected AveragingObservationList.AveragingObservationListBuilder averagingObservations;
        protected MarketDisruption.MarketDisruptionBuilder marketDisruption;

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule() {
            return this.schedule;
        }

        @Override
        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int index) {
            if (this.schedule == null) {
                this.schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();
            }
            return (AveragingSchedule.AveragingScheduleBuilder)this.getIndex(this.schedule, index, () -> {
                AveragingSchedule.AveragingScheduleBuilder newSchedule = AveragingSchedule.builder();
                return newSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="averagingDateTimes")
        @RuneAttribute(value="averagingDateTimes")
        public DateTimeList.DateTimeListBuilder getAveragingDateTimes() {
            return this.averagingDateTimes;
        }

        @Override
        public DateTimeList.DateTimeListBuilder getOrCreateAveragingDateTimes() {
            DateTimeList.DateTimeListBuilder result = this.averagingDateTimes != null ? this.averagingDateTimes : (this.averagingDateTimes = DateTimeList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingObservations")
        @RuneAttribute(value="averagingObservations")
        public AveragingObservationList.AveragingObservationListBuilder getAveragingObservations() {
            return this.averagingObservations;
        }

        @Override
        public AveragingObservationList.AveragingObservationListBuilder getOrCreateAveragingObservations() {
            AveragingObservationList.AveragingObservationListBuilder result = this.averagingObservations != null ? this.averagingObservations : (this.averagingObservations = AveragingObservationList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public MarketDisruption.MarketDisruptionBuilder getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        public MarketDisruption.MarketDisruptionBuilder getOrCreateMarketDisruption() {
            MarketDisruption.MarketDisruptionBuilder result = this.marketDisruption != null ? this.marketDisruption : (this.marketDisruption = MarketDisruption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public AveragingPeriodBuilder addSchedule(AveragingSchedule _schedule) {
            if (_schedule != null) {
                this.schedule.add(_schedule.toBuilder());
            }
            return this;
        }

        @Override
        public AveragingPeriodBuilder addSchedule(AveragingSchedule _schedule, int idx) {
            this.getIndex(this.schedule, idx, () -> _schedule.toBuilder());
            return this;
        }

        @Override
        public AveragingPeriodBuilder addSchedule(List<? extends AveragingSchedule> schedules) {
            if (schedules != null) {
                for (AveragingSchedule averagingSchedule : schedules) {
                    this.schedule.add(averagingSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="schedule")
        public AveragingPeriodBuilder setSchedule(List<? extends AveragingSchedule> schedules) {
            this.schedule = schedules == null ? new ArrayList<AveragingSchedule.AveragingScheduleBuilder>() : (List)schedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingDateTimes")
        @RuneAttribute(value="averagingDateTimes")
        public AveragingPeriodBuilder setAveragingDateTimes(DateTimeList _averagingDateTimes) {
            this.averagingDateTimes = _averagingDateTimes == null ? null : _averagingDateTimes.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingObservations")
        @RuneAttribute(value="averagingObservations")
        public AveragingPeriodBuilder setAveragingObservations(AveragingObservationList _averagingObservations) {
            this.averagingObservations = _averagingObservations == null ? null : _averagingObservations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public AveragingPeriodBuilder setMarketDisruption(MarketDisruption _marketDisruption) {
            this.marketDisruption = _marketDisruption == null ? null : _marketDisruption.toBuilder();
            return this;
        }

        @Override
        public AveragingPeriod build() {
            return new AveragingPeriodImpl(this);
        }

        @Override
        public AveragingPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public AveragingPeriodBuilder prune() {
            this.schedule = this.schedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.averagingDateTimes != null && !this.averagingDateTimes.prune().hasData()) {
                this.averagingDateTimes = null;
            }
            if (this.averagingObservations != null && !this.averagingObservations.prune().hasData()) {
                this.averagingObservations = null;
            }
            if (this.marketDisruption != null && !this.marketDisruption.prune().hasData()) {
                this.marketDisruption = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSchedule() != null && this.getSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAveragingDateTimes() != null && this.getAveragingDateTimes().hasData()) {
                return true;
            }
            if (this.getAveragingObservations() != null && this.getAveragingObservations().hasData()) {
                return true;
            }
            return this.getMarketDisruption() != null && this.getMarketDisruption().hasData();
        }

        public AveragingPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AveragingPeriodBuilder o = (AveragingPeriodBuilder)other;
            merger.mergeRosetta(this.getSchedule(), o.getSchedule(), this::getOrCreateSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingDateTimes(), (RosettaModelObjectBuilder)o.getAveragingDateTimes(), this::setAveragingDateTimes);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingObservations(), (RosettaModelObjectBuilder)o.getAveragingObservations(), this::setAveragingObservations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarketDisruption(), (RosettaModelObjectBuilder)o.getMarketDisruption(), this::setMarketDisruption);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingPeriod _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.averagingDateTimes, _that.getAveragingDateTimes())) {
                return false;
            }
            if (!Objects.equals(this.averagingObservations, _that.getAveragingObservations())) {
                return false;
            }
            return Objects.equals(this.marketDisruption, _that.getMarketDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.averagingDateTimes != null ? this.averagingDateTimes.hashCode() : 0);
            _result = 31 * _result + (this.averagingObservations != null ? this.averagingObservations.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingPeriodBuilder {schedule=" + this.schedule + ", averagingDateTimes=" + this.averagingDateTimes + ", averagingObservations=" + this.averagingObservations + ", marketDisruption=" + this.marketDisruption + '}';
        }
    }

    public static interface AveragingPeriodBuilder
    extends AveragingPeriod,
    RosettaModelObjectBuilder {
        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int var1);

        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule();

        public DateTimeList.DateTimeListBuilder getOrCreateAveragingDateTimes();

        @Override
        public DateTimeList.DateTimeListBuilder getAveragingDateTimes();

        public AveragingObservationList.AveragingObservationListBuilder getOrCreateAveragingObservations();

        @Override
        public AveragingObservationList.AveragingObservationListBuilder getAveragingObservations();

        public MarketDisruption.MarketDisruptionBuilder getOrCreateMarketDisruption();

        @Override
        public MarketDisruption.MarketDisruptionBuilder getMarketDisruption();

        public AveragingPeriodBuilder addSchedule(AveragingSchedule var1);

        public AveragingPeriodBuilder addSchedule(AveragingSchedule var1, int var2);

        public AveragingPeriodBuilder addSchedule(List<? extends AveragingSchedule> var1);

        public AveragingPeriodBuilder setSchedule(List<? extends AveragingSchedule> var1);

        public AveragingPeriodBuilder setAveragingDateTimes(DateTimeList var1);

        public AveragingPeriodBuilder setAveragingObservations(AveragingObservationList var1);

        public AveragingPeriodBuilder setMarketDisruption(MarketDisruption var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.AveragingScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingDateTimes"), processor, DateTimeList.DateTimeListBuilder.class, this.getAveragingDateTimes(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingObservations"), processor, AveragingObservationList.AveragingObservationListBuilder.class, this.getAveragingObservations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marketDisruption"), processor, MarketDisruption.MarketDisruptionBuilder.class, this.getMarketDisruption(), new AttributeMeta[0]);
        }

        public AveragingPeriodBuilder prune();
    }

    public static class AveragingPeriodImpl
    implements AveragingPeriod {
        private final List<? extends AveragingSchedule> schedule;
        private final DateTimeList averagingDateTimes;
        private final AveragingObservationList averagingObservations;
        private final MarketDisruption marketDisruption;

        protected AveragingPeriodImpl(AveragingPeriodBuilder builder) {
            this.schedule = Optional.ofNullable(builder.getSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.averagingDateTimes = Optional.ofNullable(builder.getAveragingDateTimes()).map(f -> f.build()).orElse(null);
            this.averagingObservations = Optional.ofNullable(builder.getAveragingObservations()).map(f -> f.build()).orElse(null);
            this.marketDisruption = Optional.ofNullable(builder.getMarketDisruption()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public List<? extends AveragingSchedule> getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="averagingDateTimes")
        @RuneAttribute(value="averagingDateTimes")
        public DateTimeList getAveragingDateTimes() {
            return this.averagingDateTimes;
        }

        @Override
        @RosettaAttribute(value="averagingObservations")
        @RuneAttribute(value="averagingObservations")
        public AveragingObservationList getAveragingObservations() {
            return this.averagingObservations;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public MarketDisruption getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        public AveragingPeriod build() {
            return this;
        }

        @Override
        public AveragingPeriodBuilder toBuilder() {
            AveragingPeriodBuilder builder = AveragingPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AveragingPeriodBuilder builder) {
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getAveragingDateTimes()).ifPresent(builder::setAveragingDateTimes);
            Optional.ofNullable(this.getAveragingObservations()).ifPresent(builder::setAveragingObservations);
            Optional.ofNullable(this.getMarketDisruption()).ifPresent(builder::setMarketDisruption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingPeriod _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.averagingDateTimes, _that.getAveragingDateTimes())) {
                return false;
            }
            if (!Objects.equals(this.averagingObservations, _that.getAveragingObservations())) {
                return false;
            }
            return Objects.equals(this.marketDisruption, _that.getMarketDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.averagingDateTimes != null ? this.averagingDateTimes.hashCode() : 0);
            _result = 31 * _result + (this.averagingObservations != null ? this.averagingObservations.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingPeriod {schedule=" + this.schedule + ", averagingDateTimes=" + this.averagingDateTimes + ", averagingObservations=" + this.averagingObservations + ", marketDisruption=" + this.marketDisruption + '}';
        }
    }
}

