/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractFacilityEvent;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.AccrualTypeId;
import fpml.confirmation.AccruingFeePaymentSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.BusinessEventPartiesModel;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.LoanLegalActionReference;
import fpml.confirmation.MoneyWithParticipantShare;
import fpml.confirmation.PeriodModel;
import fpml.confirmation.meta.AccruingFeePaymentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AccruingFeePayment", builder=AccruingFeePaymentBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AccruingFeePayment", model="fpml", builder=AccruingFeePaymentBuilderImpl.class, version="0.17.2")
public interface AccruingFeePayment
extends AbstractFacilityEvent {
    public static final AccruingFeePaymentMeta metaData = new AccruingFeePaymentMeta();

    public AccrualTypeId getId();

    public PeriodModel getPeriodModel();

    public MoneyWithParticipantShare getAmount();

    public AccruingFeePaymentSequence getAccruingFeePaymentSequence();

    @Override
    public AccruingFeePayment build();

    @Override
    public AccruingFeePaymentBuilder toBuilder();

    public static AccruingFeePaymentBuilder builder() {
        return new AccruingFeePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends AccruingFeePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccruingFeePayment> getType() {
        return AccruingFeePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("id"), processor, AccrualTypeId.class, this.getId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accruingFeePaymentSequence"), processor, AccruingFeePaymentSequence.class, this.getAccruingFeePaymentSequence(), new AttributeMeta[0]);
    }

    public static class AccruingFeePaymentBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements AccruingFeePaymentBuilder {
        protected AccrualTypeId.AccrualTypeIdBuilder id;
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder accruingFeePaymentSequence;

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccrualTypeId.AccrualTypeIdBuilder getId() {
            return this.id;
        }

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateId() {
            AccrualTypeId.AccrualTypeIdBuilder result = this.id != null ? this.id : (this.id = AccrualTypeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accruingFeePaymentSequence")
        @RuneAttribute(value="accruingFeePaymentSequence")
        public AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder getAccruingFeePaymentSequence() {
            return this.accruingFeePaymentSequence;
        }

        @Override
        public AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder getOrCreateAccruingFeePaymentSequence() {
            AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder result = this.accruingFeePaymentSequence != null ? this.accruingFeePaymentSequence : (this.accruingFeePaymentSequence = AccruingFeePaymentSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AccruingFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AccruingFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AccruingFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AccruingFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AccruingFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AccruingFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AccruingFeePaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AccruingFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AccruingFeePaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AccruingFeePaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public AccruingFeePaymentBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccruingFeePaymentBuilder setId(AccrualTypeId _id) {
            this.id = _id == null ? null : _id.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public AccruingFeePaymentBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public AccruingFeePaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accruingFeePaymentSequence")
        @RuneAttribute(value="accruingFeePaymentSequence")
        public AccruingFeePaymentBuilder setAccruingFeePaymentSequence(AccruingFeePaymentSequence _accruingFeePaymentSequence) {
            this.accruingFeePaymentSequence = _accruingFeePaymentSequence == null ? null : _accruingFeePaymentSequence.toBuilder();
            return this;
        }

        @Override
        public AccruingFeePayment build() {
            return new AccruingFeePaymentImpl(this);
        }

        @Override
        public AccruingFeePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public AccruingFeePaymentBuilder prune() {
            super.prune();
            if (this.id != null && !this.id.prune().hasData()) {
                this.id = null;
            }
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.accruingFeePaymentSequence != null && !this.accruingFeePaymentSequence.prune().hasData()) {
                this.accruingFeePaymentSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getId() != null && this.getId().hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getAccruingFeePaymentSequence() != null && this.getAccruingFeePaymentSequence().hasData();
        }

        @Override
        public AccruingFeePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AccruingFeePaymentBuilder o = (AccruingFeePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getId(), (RosettaModelObjectBuilder)o.getId(), this::setId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccruingFeePaymentSequence(), (RosettaModelObjectBuilder)o.getAccruingFeePaymentSequence(), this::setAccruingFeePaymentSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingFeePayment _that = (AccruingFeePayment)this.getType().cast(o);
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.accruingFeePaymentSequence, _that.getAccruingFeePaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accruingFeePaymentSequence != null ? this.accruingFeePaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingFeePaymentBuilder {id=" + this.id + ", periodModel=" + this.periodModel + ", amount=" + this.amount + ", accruingFeePaymentSequence=" + this.accruingFeePaymentSequence + '}' + " " + super.toString();
        }
    }

    public static interface AccruingFeePaymentBuilder
    extends AccruingFeePayment,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateId();

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getId();

        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder getOrCreateAccruingFeePaymentSequence();

        @Override
        public AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder getAccruingFeePaymentSequence();

        @Override
        public AccruingFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AccruingFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AccruingFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AccruingFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AccruingFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AccruingFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AccruingFeePaymentBuilder setComment(String var1);

        @Override
        public AccruingFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AccruingFeePaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AccruingFeePaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public AccruingFeePaymentBuilder setFacilityReference(FacilityReference var1);

        public AccruingFeePaymentBuilder setId(AccrualTypeId var1);

        public AccruingFeePaymentBuilder setPeriodModel(PeriodModel var1);

        public AccruingFeePaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public AccruingFeePaymentBuilder setAccruingFeePaymentSequence(AccruingFeePaymentSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("id"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, this.getId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accruingFeePaymentSequence"), processor, AccruingFeePaymentSequence.AccruingFeePaymentSequenceBuilder.class, this.getAccruingFeePaymentSequence(), new AttributeMeta[0]);
        }

        @Override
        public AccruingFeePaymentBuilder prune();
    }

    public static class AccruingFeePaymentImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements AccruingFeePayment {
        private final AccrualTypeId id;
        private final PeriodModel periodModel;
        private final MoneyWithParticipantShare amount;
        private final AccruingFeePaymentSequence accruingFeePaymentSequence;

        protected AccruingFeePaymentImpl(AccruingFeePaymentBuilder builder) {
            super(builder);
            this.id = Optional.ofNullable(builder.getId()).map(f -> f.build()).orElse(null);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.accruingFeePaymentSequence = Optional.ofNullable(builder.getAccruingFeePaymentSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccrualTypeId getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="accruingFeePaymentSequence")
        @RuneAttribute(value="accruingFeePaymentSequence")
        public AccruingFeePaymentSequence getAccruingFeePaymentSequence() {
            return this.accruingFeePaymentSequence;
        }

        @Override
        public AccruingFeePayment build() {
            return this;
        }

        @Override
        public AccruingFeePaymentBuilder toBuilder() {
            AccruingFeePaymentBuilder builder = AccruingFeePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccruingFeePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAccruingFeePaymentSequence()).ifPresent(builder::setAccruingFeePaymentSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingFeePayment _that = (AccruingFeePayment)this.getType().cast(o);
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.accruingFeePaymentSequence, _that.getAccruingFeePaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accruingFeePaymentSequence != null ? this.accruingFeePaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingFeePayment {id=" + this.id + ", periodModel=" + this.periodModel + ", amount=" + this.amount + ", accruingFeePaymentSequence=" + this.accruingFeePaymentSequence + '}' + " " + super.toString();
        }
    }
}

