/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.PartyReference;
import fpml.confirmation.meta.AccountSequenceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AccountSequence", builder=AccountSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AccountSequence", model="fpml", builder=AccountSequenceBuilderImpl.class, version="0.17.2")
public interface AccountSequence
extends RosettaModelObject {
    public static final AccountSequenceMeta metaData = new AccountSequenceMeta();

    public PartyReference getAccountBeneficiary();

    public PartyReference getServicingParty();

    public AccountSequence build();

    public AccountSequenceBuilder toBuilder();

    public static AccountSequenceBuilder builder() {
        return new AccountSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends AccountSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccountSequence> getType() {
        return AccountSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accountBeneficiary"), processor, PartyReference.class, this.getAccountBeneficiary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("servicingParty"), processor, PartyReference.class, this.getServicingParty(), new AttributeMeta[0]);
    }

    public static class AccountSequenceBuilderImpl
    implements AccountSequenceBuilder {
        protected PartyReference.PartyReferenceBuilder accountBeneficiary;
        protected PartyReference.PartyReferenceBuilder servicingParty;

        @Override
        @RosettaAttribute(value="accountBeneficiary", isRequired=true)
        @RuneAttribute(value="accountBeneficiary", isRequired=true)
        public PartyReference.PartyReferenceBuilder getAccountBeneficiary() {
            return this.accountBeneficiary;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateAccountBeneficiary() {
            PartyReference.PartyReferenceBuilder result = this.accountBeneficiary != null ? this.accountBeneficiary : (this.accountBeneficiary = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public PartyReference.PartyReferenceBuilder getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateServicingParty() {
            PartyReference.PartyReferenceBuilder result = this.servicingParty != null ? this.servicingParty : (this.servicingParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountBeneficiary", isRequired=true)
        @RuneAttribute(value="accountBeneficiary", isRequired=true)
        public AccountSequenceBuilder setAccountBeneficiary(PartyReference _accountBeneficiary) {
            this.accountBeneficiary = _accountBeneficiary == null ? null : _accountBeneficiary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public AccountSequenceBuilder setServicingParty(PartyReference _servicingParty) {
            this.servicingParty = _servicingParty == null ? null : _servicingParty.toBuilder();
            return this;
        }

        @Override
        public AccountSequence build() {
            return new AccountSequenceImpl(this);
        }

        @Override
        public AccountSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public AccountSequenceBuilder prune() {
            if (this.accountBeneficiary != null && !this.accountBeneficiary.prune().hasData()) {
                this.accountBeneficiary = null;
            }
            if (this.servicingParty != null && !this.servicingParty.prune().hasData()) {
                this.servicingParty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccountBeneficiary() != null && this.getAccountBeneficiary().hasData()) {
                return true;
            }
            return this.getServicingParty() != null && this.getServicingParty().hasData();
        }

        public AccountSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccountSequenceBuilder o = (AccountSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountBeneficiary(), (RosettaModelObjectBuilder)o.getAccountBeneficiary(), this::setAccountBeneficiary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getServicingParty(), (RosettaModelObjectBuilder)o.getServicingParty(), this::setServicingParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccountSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.accountBeneficiary, _that.getAccountBeneficiary())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountBeneficiary != null ? this.accountBeneficiary.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccountSequenceBuilder {accountBeneficiary=" + this.accountBeneficiary + ", servicingParty=" + this.servicingParty + '}';
        }
    }

    public static interface AccountSequenceBuilder
    extends AccountSequence,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateAccountBeneficiary();

        @Override
        public PartyReference.PartyReferenceBuilder getAccountBeneficiary();

        public PartyReference.PartyReferenceBuilder getOrCreateServicingParty();

        @Override
        public PartyReference.PartyReferenceBuilder getServicingParty();

        public AccountSequenceBuilder setAccountBeneficiary(PartyReference var1);

        public AccountSequenceBuilder setServicingParty(PartyReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accountBeneficiary"), processor, PartyReference.PartyReferenceBuilder.class, this.getAccountBeneficiary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("servicingParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getServicingParty(), new AttributeMeta[0]);
        }

        public AccountSequenceBuilder prune();
    }

    public static class AccountSequenceImpl
    implements AccountSequence {
        private final PartyReference accountBeneficiary;
        private final PartyReference servicingParty;

        protected AccountSequenceImpl(AccountSequenceBuilder builder) {
            this.accountBeneficiary = Optional.ofNullable(builder.getAccountBeneficiary()).map(f -> f.build()).orElse(null);
            this.servicingParty = Optional.ofNullable(builder.getServicingParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accountBeneficiary", isRequired=true)
        @RuneAttribute(value="accountBeneficiary", isRequired=true)
        public PartyReference getAccountBeneficiary() {
            return this.accountBeneficiary;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public PartyReference getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public AccountSequence build() {
            return this;
        }

        @Override
        public AccountSequenceBuilder toBuilder() {
            AccountSequenceBuilder builder = AccountSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccountSequenceBuilder builder) {
            Optional.ofNullable(this.getAccountBeneficiary()).ifPresent(builder::setAccountBeneficiary);
            Optional.ofNullable(this.getServicingParty()).ifPresent(builder::setServicingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccountSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.accountBeneficiary, _that.getAccountBeneficiary())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountBeneficiary != null ? this.accountBeneficiary.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccountSequence {accountBeneficiary=" + this.accountBeneficiary + ", servicingParty=" + this.servicingParty + '}';
        }
    }
}

