/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractFacilityEvent;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.BusinessEventPartiesModel;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.LoanContractReference;
import fpml.confirmation.LoanLegalActionReference;
import fpml.confirmation.meta.AbstractFacilityContractEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractFacilityContractEvent", builder=AbstractFacilityContractEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AbstractFacilityContractEvent", model="fpml", builder=AbstractFacilityContractEventBuilderImpl.class, version="0.17.2")
public interface AbstractFacilityContractEvent
extends AbstractFacilityEvent {
    public static final AbstractFacilityContractEventMeta metaData = new AbstractFacilityContractEventMeta();

    public List<? extends LoanContractReference> getLoanContractReference();

    @Override
    public AbstractFacilityContractEvent build();

    @Override
    public AbstractFacilityContractEventBuilder toBuilder();

    public static AbstractFacilityContractEventBuilder builder() {
        return new AbstractFacilityContractEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFacilityContractEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFacilityContractEvent> getType() {
        return AbstractFacilityContractEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
    }

    public static class AbstractFacilityContractEventBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements AbstractFacilityContractEventBuilder {
        protected List<LoanContractReference.LoanContractReferenceBuilder> loanContractReference = new ArrayList<LoanContractReference.LoanContractReferenceBuilder>();

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public List<? extends LoanContractReference.LoanContractReferenceBuilder> getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference(int index) {
            if (this.loanContractReference == null) {
                this.loanContractReference = new ArrayList<LoanContractReference.LoanContractReferenceBuilder>();
            }
            return (LoanContractReference.LoanContractReferenceBuilder)this.getIndex(this.loanContractReference, index, () -> {
                LoanContractReference.LoanContractReferenceBuilder newLoanContractReference = LoanContractReference.builder();
                return newLoanContractReference;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractFacilityContractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractFacilityContractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractFacilityContractEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractFacilityContractEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractFacilityContractEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractFacilityContractEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractFacilityContractEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractFacilityContractEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public AbstractFacilityContractEventBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public AbstractFacilityContractEventBuilder addLoanContractReference(LoanContractReference _loanContractReference) {
            if (_loanContractReference != null) {
                this.loanContractReference.add(_loanContractReference.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder addLoanContractReference(LoanContractReference _loanContractReference, int idx) {
            this.getIndex(this.loanContractReference, idx, () -> _loanContractReference.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder addLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            if (loanContractReferences != null) {
                for (LoanContractReference loanContractReference : loanContractReferences) {
                    this.loanContractReference.add(loanContractReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractReference")
        public AbstractFacilityContractEventBuilder setLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            this.loanContractReference = loanContractReferences == null ? new ArrayList<LoanContractReference.LoanContractReferenceBuilder>() : (List)loanContractReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractFacilityContractEvent build() {
            return new AbstractFacilityContractEventImpl(this);
        }

        @Override
        public AbstractFacilityContractEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder prune() {
            super.prune();
            this.loanContractReference = this.loanContractReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLoanContractReference() != null && this.getLoanContractReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AbstractFacilityContractEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFacilityContractEventBuilder o = (AbstractFacilityContractEventBuilder)other;
            merger.mergeRosetta(this.getLoanContractReference(), o.getLoanContractReference(), this::getOrCreateLoanContractReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityContractEvent _that = (AbstractFacilityContractEvent)this.getType().cast(o);
            return ListEquals.listEquals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityContractEventBuilder {loanContractReference=" + this.loanContractReference + '}' + " " + super.toString();
        }
    }

    public static interface AbstractFacilityContractEventBuilder
    extends AbstractFacilityContractEvent,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference(int var1);

        public List<? extends LoanContractReference.LoanContractReferenceBuilder> getLoanContractReference();

        @Override
        public AbstractFacilityContractEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractFacilityContractEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractFacilityContractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityContractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityContractEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractFacilityContractEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractFacilityContractEventBuilder setComment(String var1);

        @Override
        public AbstractFacilityContractEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AbstractFacilityContractEventBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractFacilityContractEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public AbstractFacilityContractEventBuilder setFacilityReference(FacilityReference var1);

        public AbstractFacilityContractEventBuilder addLoanContractReference(LoanContractReference var1);

        public AbstractFacilityContractEventBuilder addLoanContractReference(LoanContractReference var1, int var2);

        public AbstractFacilityContractEventBuilder addLoanContractReference(List<? extends LoanContractReference> var1);

        public AbstractFacilityContractEventBuilder setLoanContractReference(List<? extends LoanContractReference> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractFacilityContractEventBuilder prune();
    }

    public static class AbstractFacilityContractEventImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements AbstractFacilityContractEvent {
        private final List<? extends LoanContractReference> loanContractReference;

        protected AbstractFacilityContractEventImpl(AbstractFacilityContractEventBuilder builder) {
            super(builder);
            this.loanContractReference = Optional.ofNullable(builder.getLoanContractReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public List<? extends LoanContractReference> getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public AbstractFacilityContractEvent build() {
            return this;
        }

        @Override
        public AbstractFacilityContractEventBuilder toBuilder() {
            AbstractFacilityContractEventBuilder builder = AbstractFacilityContractEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFacilityContractEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanContractReference()).ifPresent(builder::setLoanContractReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityContractEvent _that = (AbstractFacilityContractEvent)this.getType().cast(o);
            return ListEquals.listEquals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityContractEvent {loanContractReference=" + this.loanContractReference + '}' + " " + super.toString();
        }
    }
}

