/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.product.common.settlement.PrincipalPaymentSchedule;
import cdm.product.common.settlement.meta.PrincipalPaymentsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PrincipalPayments", builder=PrincipalPaymentsBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="PrincipalPayments", model="cdm", builder=PrincipalPaymentsBuilderImpl.class, version="7.0.0-dev.50")
public interface PrincipalPayments
extends RosettaModelObject,
GlobalKey {
    public static final PrincipalPaymentsMeta metaData = new PrincipalPaymentsMeta();

    public Boolean getInitialPayment();

    public Boolean getFinalPayment();

    public Boolean getIntermediatePayment();

    public List<String> getVaryingLegNotionalCurrency();

    public PrincipalPaymentSchedule getPrincipalPaymentSchedule();

    public MetaFields getMeta();

    public PrincipalPayments build();

    public PrincipalPaymentsBuilder toBuilder();

    public static PrincipalPaymentsBuilder builder() {
        return new PrincipalPaymentsBuilderImpl();
    }

    default public RosettaMetaData<? extends PrincipalPayments> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PrincipalPayments> getType() {
        return PrincipalPayments.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialPayment"), Boolean.class, (Object)this.getInitialPayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalPayment"), Boolean.class, (Object)this.getFinalPayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intermediatePayment"), Boolean.class, (Object)this.getIntermediatePayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("varyingLegNotionalCurrency"), String.class, this.getVaryingLegNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPaymentSchedule"), processor, PrincipalPaymentSchedule.class, this.getPrincipalPaymentSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PrincipalPaymentsBuilderImpl
    implements PrincipalPaymentsBuilder {
        protected Boolean initialPayment;
        protected Boolean finalPayment;
        protected Boolean intermediatePayment;
        protected List<String> varyingLegNotionalCurrency = new ArrayList<String>();
        protected PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder principalPaymentSchedule;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="initialPayment", isRequired=true)
        @RuneAttribute(value="initialPayment", isRequired=true)
        public Boolean getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        @RosettaAttribute(value="finalPayment", isRequired=true)
        @RuneAttribute(value="finalPayment", isRequired=true)
        public Boolean getFinalPayment() {
            return this.finalPayment;
        }

        @Override
        @RosettaAttribute(value="intermediatePayment", isRequired=true)
        @RuneAttribute(value="intermediatePayment", isRequired=true)
        public Boolean getIntermediatePayment() {
            return this.intermediatePayment;
        }

        @Override
        @RosettaAttribute(value="varyingLegNotionalCurrency")
        @RuneAttribute(value="varyingLegNotionalCurrency")
        public List<String> getVaryingLegNotionalCurrency() {
            return this.varyingLegNotionalCurrency;
        }

        @Override
        @RosettaAttribute(value="principalPaymentSchedule")
        @RuneAttribute(value="principalPaymentSchedule")
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getPrincipalPaymentSchedule() {
            return this.principalPaymentSchedule;
        }

        @Override
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getOrCreatePrincipalPaymentSchedule() {
            PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder result = this.principalPaymentSchedule != null ? this.principalPaymentSchedule : (this.principalPaymentSchedule = PrincipalPaymentSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialPayment", isRequired=true)
        @RuneAttribute(value="initialPayment", isRequired=true)
        public PrincipalPaymentsBuilder setInitialPayment(Boolean _initialPayment) {
            this.initialPayment = _initialPayment == null ? null : _initialPayment;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalPayment", isRequired=true)
        @RuneAttribute(value="finalPayment", isRequired=true)
        public PrincipalPaymentsBuilder setFinalPayment(Boolean _finalPayment) {
            this.finalPayment = _finalPayment == null ? null : _finalPayment;
            return this;
        }

        @Override
        @RosettaAttribute(value="intermediatePayment", isRequired=true)
        @RuneAttribute(value="intermediatePayment", isRequired=true)
        public PrincipalPaymentsBuilder setIntermediatePayment(Boolean _intermediatePayment) {
            this.intermediatePayment = _intermediatePayment == null ? null : _intermediatePayment;
            return this;
        }

        @Override
        @RosettaAttribute(value="varyingLegNotionalCurrency")
        @RuneAttribute(value="varyingLegNotionalCurrency")
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String _varyingLegNotionalCurrency) {
            if (_varyingLegNotionalCurrency != null) {
                this.varyingLegNotionalCurrency.add(_varyingLegNotionalCurrency);
            }
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String _varyingLegNotionalCurrency, int idx) {
            this.getIndex(this.varyingLegNotionalCurrency, idx, () -> _varyingLegNotionalCurrency);
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(List<String> varyingLegNotionalCurrencys) {
            if (varyingLegNotionalCurrencys != null) {
                for (String toAdd : varyingLegNotionalCurrencys) {
                    this.varyingLegNotionalCurrency.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="varyingLegNotionalCurrency")
        public PrincipalPaymentsBuilder setVaryingLegNotionalCurrency(List<String> varyingLegNotionalCurrencys) {
            this.varyingLegNotionalCurrency = varyingLegNotionalCurrencys == null ? new ArrayList<String>() : (List)varyingLegNotionalCurrencys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPaymentSchedule")
        @RuneAttribute(value="principalPaymentSchedule")
        public PrincipalPaymentsBuilder setPrincipalPaymentSchedule(PrincipalPaymentSchedule _principalPaymentSchedule) {
            this.principalPaymentSchedule = _principalPaymentSchedule == null ? null : _principalPaymentSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PrincipalPaymentsBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PrincipalPayments build() {
            return new PrincipalPaymentsImpl(this);
        }

        @Override
        public PrincipalPaymentsBuilder toBuilder() {
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder prune() {
            if (this.principalPaymentSchedule != null && !this.principalPaymentSchedule.prune().hasData()) {
                this.principalPaymentSchedule = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInitialPayment() != null) {
                return true;
            }
            if (this.getFinalPayment() != null) {
                return true;
            }
            if (this.getIntermediatePayment() != null) {
                return true;
            }
            if (this.getVaryingLegNotionalCurrency() != null && !this.getVaryingLegNotionalCurrency().isEmpty()) {
                return true;
            }
            return this.getPrincipalPaymentSchedule() != null && this.getPrincipalPaymentSchedule().hasData();
        }

        public PrincipalPaymentsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrincipalPaymentsBuilder o = (PrincipalPaymentsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalPaymentSchedule(), (RosettaModelObjectBuilder)o.getPrincipalPaymentSchedule(), this::setPrincipalPaymentSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getInitialPayment(), (Object)o.getInitialPayment(), this::setInitialPayment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalPayment(), (Object)o.getFinalPayment(), this::setFinalPayment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntermediatePayment(), (Object)o.getIntermediatePayment(), this::setIntermediatePayment, new AttributeMeta[0]);
            merger.mergeBasic(this.getVaryingLegNotionalCurrency(), o.getVaryingLegNotionalCurrency(), this::addVaryingLegNotionalCurrency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayments _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!Objects.equals(this.finalPayment, _that.getFinalPayment())) {
                return false;
            }
            if (!Objects.equals(this.intermediatePayment, _that.getIntermediatePayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.varyingLegNotionalCurrency, _that.getVaryingLegNotionalCurrency())) {
                return false;
            }
            if (!Objects.equals(this.principalPaymentSchedule, _that.getPrincipalPaymentSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.finalPayment != null ? this.finalPayment.hashCode() : 0);
            _result = 31 * _result + (this.intermediatePayment != null ? this.intermediatePayment.hashCode() : 0);
            _result = 31 * _result + (this.varyingLegNotionalCurrency != null ? this.varyingLegNotionalCurrency.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentSchedule != null ? this.principalPaymentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPaymentsBuilder {initialPayment=" + this.initialPayment + ", finalPayment=" + this.finalPayment + ", intermediatePayment=" + this.intermediatePayment + ", varyingLegNotionalCurrency=" + this.varyingLegNotionalCurrency + ", principalPaymentSchedule=" + this.principalPaymentSchedule + ", meta=" + this.meta + '}';
        }
    }

    public static interface PrincipalPaymentsBuilder
    extends PrincipalPayments,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getOrCreatePrincipalPaymentSchedule();

        @Override
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getPrincipalPaymentSchedule();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PrincipalPaymentsBuilder setInitialPayment(Boolean var1);

        public PrincipalPaymentsBuilder setFinalPayment(Boolean var1);

        public PrincipalPaymentsBuilder setIntermediatePayment(Boolean var1);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String var1);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String var1, int var2);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(List<String> var1);

        public PrincipalPaymentsBuilder setVaryingLegNotionalCurrency(List<String> var1);

        public PrincipalPaymentsBuilder setPrincipalPaymentSchedule(PrincipalPaymentSchedule var1);

        public PrincipalPaymentsBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialPayment"), Boolean.class, (Object)this.getInitialPayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalPayment"), Boolean.class, (Object)this.getFinalPayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intermediatePayment"), Boolean.class, (Object)this.getIntermediatePayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("varyingLegNotionalCurrency"), String.class, this.getVaryingLegNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPaymentSchedule"), processor, PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder.class, this.getPrincipalPaymentSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PrincipalPaymentsBuilder prune();
    }

    public static class PrincipalPaymentsImpl
    implements PrincipalPayments {
        private final Boolean initialPayment;
        private final Boolean finalPayment;
        private final Boolean intermediatePayment;
        private final List<String> varyingLegNotionalCurrency;
        private final PrincipalPaymentSchedule principalPaymentSchedule;
        private final MetaFields meta;

        protected PrincipalPaymentsImpl(PrincipalPaymentsBuilder builder) {
            this.initialPayment = builder.getInitialPayment();
            this.finalPayment = builder.getFinalPayment();
            this.intermediatePayment = builder.getIntermediatePayment();
            this.varyingLegNotionalCurrency = Optional.ofNullable(builder.getVaryingLegNotionalCurrency()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.principalPaymentSchedule = Optional.ofNullable(builder.getPrincipalPaymentSchedule()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="initialPayment", isRequired=true)
        @RuneAttribute(value="initialPayment", isRequired=true)
        public Boolean getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        @RosettaAttribute(value="finalPayment", isRequired=true)
        @RuneAttribute(value="finalPayment", isRequired=true)
        public Boolean getFinalPayment() {
            return this.finalPayment;
        }

        @Override
        @RosettaAttribute(value="intermediatePayment", isRequired=true)
        @RuneAttribute(value="intermediatePayment", isRequired=true)
        public Boolean getIntermediatePayment() {
            return this.intermediatePayment;
        }

        @Override
        @RosettaAttribute(value="varyingLegNotionalCurrency")
        @RuneAttribute(value="varyingLegNotionalCurrency")
        public List<String> getVaryingLegNotionalCurrency() {
            return this.varyingLegNotionalCurrency;
        }

        @Override
        @RosettaAttribute(value="principalPaymentSchedule")
        @RuneAttribute(value="principalPaymentSchedule")
        public PrincipalPaymentSchedule getPrincipalPaymentSchedule() {
            return this.principalPaymentSchedule;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PrincipalPayments build() {
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder toBuilder() {
            PrincipalPaymentsBuilder builder = PrincipalPayments.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrincipalPaymentsBuilder builder) {
            Optional.ofNullable(this.getInitialPayment()).ifPresent(builder::setInitialPayment);
            Optional.ofNullable(this.getFinalPayment()).ifPresent(builder::setFinalPayment);
            Optional.ofNullable(this.getIntermediatePayment()).ifPresent(builder::setIntermediatePayment);
            Optional.ofNullable(this.getVaryingLegNotionalCurrency()).ifPresent(builder::setVaryingLegNotionalCurrency);
            Optional.ofNullable(this.getPrincipalPaymentSchedule()).ifPresent(builder::setPrincipalPaymentSchedule);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayments _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!Objects.equals(this.finalPayment, _that.getFinalPayment())) {
                return false;
            }
            if (!Objects.equals(this.intermediatePayment, _that.getIntermediatePayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.varyingLegNotionalCurrency, _that.getVaryingLegNotionalCurrency())) {
                return false;
            }
            if (!Objects.equals(this.principalPaymentSchedule, _that.getPrincipalPaymentSchedule())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.finalPayment != null ? this.finalPayment.hashCode() : 0);
            _result = 31 * _result + (this.intermediatePayment != null ? this.intermediatePayment.hashCode() : 0);
            _result = 31 * _result + (this.varyingLegNotionalCurrency != null ? this.varyingLegNotionalCurrency.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentSchedule != null ? this.principalPaymentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPayments {initialPayment=" + this.initialPayment + ", finalPayment=" + this.finalPayment + ", intermediatePayment=" + this.intermediatePayment + ", varyingLegNotionalCurrency=" + this.varyingLegNotionalCurrency + ", principalPaymentSchedule=" + this.principalPaymentSchedule + ", meta=" + this.meta + '}';
        }
    }
}

