/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.asset.meta.CommodityPayoutMeta;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.CommodityPriceReturnTerms;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PricingDates;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AveragingCalculation;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.FxFeature;
import cdm.product.template.Underlier;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityPayout", builder=CommodityPayoutBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CommodityPayout", model="cdm", builder=CommodityPayoutBuilderImpl.class, version="7.0.0-dev.50")
public interface CommodityPayout
extends PayoutBase {
    public static final CommodityPayoutMeta metaData = new CommodityPayoutMeta();

    public AveragingCalculation getAveragingFeature();

    public CommodityPriceReturnTerms getCommodityPriceReturnTerms();

    public PricingDates getPricingDates();

    public CalculationSchedule getSchedule();

    public CalculationPeriodDates getCalculationPeriodDates();

    public PaymentDates getPaymentDates();

    public Underlier getUnderlier();

    public FxFeature getFxFeature();

    public AssetDeliveryInformation getDelivery();

    @Override
    public CommodityPayout build();

    @Override
    public CommodityPayoutBuilder toBuilder();

    public static CommodityPayoutBuilder builder() {
        return new CommodityPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityPayout> getType() {
        return CommodityPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.class, this.getAveragingFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPriceReturnTerms"), processor, CommodityPriceReturnTerms.class, this.getCommodityPriceReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingDates"), processor, PricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Underlier.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.class, this.getDelivery(), new AttributeMeta[0]);
    }

    public static class CommodityPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements CommodityPayoutBuilder {
        protected AveragingCalculation.AveragingCalculationBuilder averagingFeature;
        protected CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder commodityPriceReturnTerms;
        protected PricingDates.PricingDatesBuilder pricingDates;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;
        protected CalculationPeriodDates.CalculationPeriodDatesBuilder calculationPeriodDates;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected Underlier.UnderlierBuilder underlier;
        protected FxFeature.FxFeatureBuilder fxFeature;
        protected AssetDeliveryInformation.AssetDeliveryInformationBuilder delivery;

        @Override
        @RosettaAttribute(value="averagingFeature")
        @RuneAttribute(value="averagingFeature")
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature() {
            AveragingCalculation.AveragingCalculationBuilder result = this.averagingFeature != null ? this.averagingFeature : (this.averagingFeature = AveragingCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityPriceReturnTerms")
        @RuneAttribute(value="commodityPriceReturnTerms")
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getCommodityPriceReturnTerms() {
            return this.commodityPriceReturnTerms;
        }

        @Override
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getOrCreateCommodityPriceReturnTerms() {
            CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder result = this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms : (this.commodityPriceReturnTerms = CommodityPriceReturnTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public PricingDates.PricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public PricingDates.PricingDatesBuilder getOrCreatePricingDates() {
            PricingDates.PricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = PricingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates() {
            CalculationPeriodDates.CalculationPeriodDatesBuilder result = this.calculationPeriodDates != null ? this.calculationPeriodDates : (this.calculationPeriodDates = CalculationPeriodDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier.UnderlierBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Underlier.UnderlierBuilder getOrCreateUnderlier() {
            Underlier.UnderlierBuilder result = this.underlier != null ? this.underlier : (this.underlier = Underlier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public FxFeature.FxFeatureBuilder getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public FxFeature.FxFeatureBuilder getOrCreateFxFeature() {
            FxFeature.FxFeatureBuilder result = this.fxFeature != null ? this.fxFeature : (this.fxFeature = FxFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery() {
            return this.delivery;
        }

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery() {
            AssetDeliveryInformation.AssetDeliveryInformationBuilder result = this.delivery != null ? this.delivery : (this.delivery = AssetDeliveryInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public CommodityPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public CommodityPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public CommodityPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public CommodityPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingFeature")
        @RuneAttribute(value="averagingFeature")
        public CommodityPayoutBuilder setAveragingFeature(AveragingCalculation _averagingFeature) {
            this.averagingFeature = _averagingFeature == null ? null : _averagingFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPriceReturnTerms")
        @RuneAttribute(value="commodityPriceReturnTerms")
        public CommodityPayoutBuilder setCommodityPriceReturnTerms(CommodityPriceReturnTerms _commodityPriceReturnTerms) {
            this.commodityPriceReturnTerms = _commodityPriceReturnTerms == null ? null : _commodityPriceReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public CommodityPayoutBuilder setPricingDates(PricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CommodityPayoutBuilder setSchedule(CalculationSchedule _schedule) {
            this.schedule = _schedule == null ? null : _schedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CommodityPayoutBuilder setCalculationPeriodDates(CalculationPeriodDates _calculationPeriodDates) {
            this.calculationPeriodDates = _calculationPeriodDates == null ? null : _calculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public CommodityPayoutBuilder setPaymentDates(PaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public CommodityPayoutBuilder setUnderlier(Underlier _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public CommodityPayoutBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public CommodityPayoutBuilder setDelivery(AssetDeliveryInformation _delivery) {
            this.delivery = _delivery == null ? null : _delivery.toBuilder();
            return this;
        }

        @Override
        public CommodityPayout build() {
            return new CommodityPayoutImpl(this);
        }

        @Override
        public CommodityPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPayoutBuilder prune() {
            super.prune();
            if (this.averagingFeature != null && !this.averagingFeature.prune().hasData()) {
                this.averagingFeature = null;
            }
            if (this.commodityPriceReturnTerms != null && !this.commodityPriceReturnTerms.prune().hasData()) {
                this.commodityPriceReturnTerms = null;
            }
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.calculationPeriodDates != null && !this.calculationPeriodDates.prune().hasData()) {
                this.calculationPeriodDates = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.fxFeature != null && !this.fxFeature.prune().hasData()) {
                this.fxFeature = null;
            }
            if (this.delivery != null && !this.delivery.prune().hasData()) {
                this.delivery = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAveragingFeature() != null && this.getAveragingFeature().hasData()) {
                return true;
            }
            if (this.getCommodityPriceReturnTerms() != null && this.getCommodityPriceReturnTerms().hasData()) {
                return true;
            }
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getSchedule() != null && this.getSchedule().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodDates() != null && this.getCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getFxFeature() != null && this.getFxFeature().hasData()) {
                return true;
            }
            return this.getDelivery() != null && this.getDelivery().hasData();
        }

        @Override
        public CommodityPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityPayoutBuilder o = (CommodityPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingFeature(), (RosettaModelObjectBuilder)o.getAveragingFeature(), this::setAveragingFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityPriceReturnTerms(), (RosettaModelObjectBuilder)o.getCommodityPriceReturnTerms(), this::setCommodityPriceReturnTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getCalculationPeriodDates(), this::setCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFeature(), (RosettaModelObjectBuilder)o.getFxFeature(), this::setFxFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelivery(), (RosettaModelObjectBuilder)o.getDelivery(), this::setDelivery);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPayout _that = (CommodityPayout)this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.commodityPriceReturnTerms, _that.getCommodityPriceReturnTerms())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            return Objects.equals(this.delivery, _that.getDelivery());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPayoutBuilder {averagingFeature=" + this.averagingFeature + ", commodityPriceReturnTerms=" + this.commodityPriceReturnTerms + ", pricingDates=" + this.pricingDates + ", schedule=" + this.schedule + ", calculationPeriodDates=" + this.calculationPeriodDates + ", paymentDates=" + this.paymentDates + ", underlier=" + this.underlier + ", fxFeature=" + this.fxFeature + ", delivery=" + this.delivery + '}' + " " + super.toString();
        }
    }

    public static interface CommodityPayoutBuilder
    extends CommodityPayout,
    PayoutBase.PayoutBaseBuilder {
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature();

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature();

        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getOrCreateCommodityPriceReturnTerms();

        @Override
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getCommodityPriceReturnTerms();

        public PricingDates.PricingDatesBuilder getOrCreatePricingDates();

        @Override
        public PricingDates.PricingDatesBuilder getPricingDates();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates();

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public Underlier.UnderlierBuilder getOrCreateUnderlier();

        @Override
        public Underlier.UnderlierBuilder getUnderlier();

        public FxFeature.FxFeatureBuilder getOrCreateFxFeature();

        @Override
        public FxFeature.FxFeatureBuilder getFxFeature();

        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery();

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery();

        @Override
        public CommodityPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public CommodityPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public CommodityPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public CommodityPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public CommodityPayoutBuilder setAveragingFeature(AveragingCalculation var1);

        public CommodityPayoutBuilder setCommodityPriceReturnTerms(CommodityPriceReturnTerms var1);

        public CommodityPayoutBuilder setPricingDates(PricingDates var1);

        public CommodityPayoutBuilder setSchedule(CalculationSchedule var1);

        public CommodityPayoutBuilder setCalculationPeriodDates(CalculationPeriodDates var1);

        public CommodityPayoutBuilder setPaymentDates(PaymentDates var1);

        public CommodityPayoutBuilder setUnderlier(Underlier var1);

        public CommodityPayoutBuilder setFxFeature(FxFeature var1);

        public CommodityPayoutBuilder setDelivery(AssetDeliveryInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.AveragingCalculationBuilder.class, this.getAveragingFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPriceReturnTerms"), processor, CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder.class, this.getCommodityPriceReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingDates"), processor, PricingDates.PricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.CalculationPeriodDatesBuilder.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Underlier.UnderlierBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.AssetDeliveryInformationBuilder.class, this.getDelivery(), new AttributeMeta[0]);
        }

        @Override
        public CommodityPayoutBuilder prune();
    }

    public static class CommodityPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements CommodityPayout {
        private final AveragingCalculation averagingFeature;
        private final CommodityPriceReturnTerms commodityPriceReturnTerms;
        private final PricingDates pricingDates;
        private final CalculationSchedule schedule;
        private final CalculationPeriodDates calculationPeriodDates;
        private final PaymentDates paymentDates;
        private final Underlier underlier;
        private final FxFeature fxFeature;
        private final AssetDeliveryInformation delivery;

        protected CommodityPayoutImpl(CommodityPayoutBuilder builder) {
            super(builder);
            this.averagingFeature = Optional.ofNullable(builder.getAveragingFeature()).map(f -> f.build()).orElse(null);
            this.commodityPriceReturnTerms = Optional.ofNullable(builder.getCommodityPriceReturnTerms()).map(f -> f.build()).orElse(null);
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.calculationPeriodDates = Optional.ofNullable(builder.getCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.fxFeature = Optional.ofNullable(builder.getFxFeature()).map(f -> f.build()).orElse(null);
            this.delivery = Optional.ofNullable(builder.getDelivery()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="averagingFeature")
        @RuneAttribute(value="averagingFeature")
        public AveragingCalculation getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        @RosettaAttribute(value="commodityPriceReturnTerms")
        @RuneAttribute(value="commodityPriceReturnTerms")
        public CommodityPriceReturnTerms getCommodityPriceReturnTerms() {
            return this.commodityPriceReturnTerms;
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public PricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public FxFeature getFxFeature() {
            return this.fxFeature;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation getDelivery() {
            return this.delivery;
        }

        @Override
        public CommodityPayout build() {
            return this;
        }

        @Override
        public CommodityPayoutBuilder toBuilder() {
            CommodityPayoutBuilder builder = CommodityPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAveragingFeature()).ifPresent(builder::setAveragingFeature);
            Optional.ofNullable(this.getCommodityPriceReturnTerms()).ifPresent(builder::setCommodityPriceReturnTerms);
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getCalculationPeriodDates()).ifPresent(builder::setCalculationPeriodDates);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getFxFeature()).ifPresent(builder::setFxFeature);
            Optional.ofNullable(this.getDelivery()).ifPresent(builder::setDelivery);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPayout _that = (CommodityPayout)this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.commodityPriceReturnTerms, _that.getCommodityPriceReturnTerms())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            return Objects.equals(this.delivery, _that.getDelivery());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPayout {averagingFeature=" + this.averagingFeature + ", commodityPriceReturnTerms=" + this.commodityPriceReturnTerms + ", pricingDates=" + this.pricingDates + ", schedule=" + this.schedule + ", calculationPeriodDates=" + this.calculationPeriodDates + ", paymentDates=" + this.paymentDates + ", underlier=" + this.underlier + ", fxFeature=" + this.fxFeature + ", delivery=" + this.delivery + '}' + " " + super.toString();
        }
    }
}

