/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event.functions;

import cdm.base.math.AveragingCalculationMethod;
import cdm.observable.event.Observation;
import cdm.observable.event.ObservationIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveObservationDefault.class)
public abstract class ResolveObservation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Observation evaluate(List<? extends ObservationIdentifier> identifiers, AveragingCalculationMethod averagingMethod) {
        Observation observation;
        Observation.ObservationBuilder observationBuilder = this.doEvaluate(identifiers, averagingMethod);
        if (observationBuilder == null) {
            observation = null;
        } else {
            observation = observationBuilder.build();
            this.objectValidator.validate(Observation.class, (RosettaModelObject)observation);
        }
        return observation;
    }

    protected abstract Observation.ObservationBuilder doEvaluate(List<? extends ObservationIdentifier> var1, AveragingCalculationMethod var2);

    public static class ResolveObservationDefault
    extends ResolveObservation {
        @Override
        protected Observation.ObservationBuilder doEvaluate(List<? extends ObservationIdentifier> identifiers, AveragingCalculationMethod averagingMethod) {
            if (identifiers == null) {
                identifiers = Collections.emptyList();
            }
            Observation.ObservationBuilder observation = Observation.builder();
            return this.assignOutput(observation, identifiers, averagingMethod);
        }

        protected Observation.ObservationBuilder assignOutput(Observation.ObservationBuilder observation, List<? extends ObservationIdentifier> identifiers, AveragingCalculationMethod averagingMethod) {
            return Optional.ofNullable(observation).map(o -> o.prune()).orElse(null);
        }
    }
}

