/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.template.SettlementPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=StandardizedScheduleEquityForwardNotionalAmountDefault.class)
public abstract class StandardizedScheduleEquityForwardNotionalAmount
implements RosettaFunction {
    public BigDecimal evaluate(SettlementPayout settlementPayout) {
        BigDecimal amount = this.doEvaluate(settlementPayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(SettlementPayout var1);

    protected abstract MapperS<BigDecimal> forwardPrice(SettlementPayout var1);

    protected abstract MapperS<BigDecimal> notionalQuantity(SettlementPayout var1);

    public static class StandardizedScheduleEquityForwardNotionalAmountDefault
    extends StandardizedScheduleEquityForwardNotionalAmount {
        @Override
        protected BigDecimal doEvaluate(SettlementPayout settlementPayout) {
            BigDecimal amount = null;
            return this.assignOutput(amount, settlementPayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, SettlementPayout settlementPayout) {
            amount = (BigDecimal)MapperMaths.multiply(this.forwardPrice(settlementPayout), this.notionalQuantity(settlementPayout)).get();
            return amount;
        }

        @Override
        protected MapperS<BigDecimal> forwardPrice(SettlementPayout settlementPayout) {
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperS.of((Object)settlementPayout).map("getPriceQuantity", _settlementPayout -> _settlementPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
            return (referenceWithMetaPriceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaPriceSchedule.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> notionalQuantity(SettlementPayout settlementPayout) {
            MapperS thenArg = MapperS.of((Object)settlementPayout).map("getPriceQuantity", _settlementPayout -> _settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            MapperS ifThenElseResult = ExpressionOperators.exists((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperMaths.multiply((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue())) : thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
            return ifThenElseResult;
        }
    }
}

