/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.event.common.Exposure;
import cdm.event.common.Trade;
import cdm.event.common.Valuation;
import cdm.event.common.ValuationTypeEnum;
import cdm.event.position.Position;
import cdm.event.position.metafields.ReferenceWithMetaPortfolioState;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleInitialMargin;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.StandardizedScheduleTradeInfo;
import cdm.margin.schedule.functions.BuildStandardizedSchedule;
import cdm.margin.schedule.functions.GetGrossInitialMarginFromStandardizedSchedule;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNetInitialMarginFromExposureDefault.class)
public abstract class GetNetInitialMarginFromExposure
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BuildStandardizedSchedule buildStandardizedSchedule;
    @Inject
    protected GetGrossInitialMarginFromStandardizedSchedule getGrossInitialMarginFromStandardizedSchedule;

    public StandardizedScheduleInitialMargin evaluate(Exposure exposure) {
        StandardizedScheduleInitialMargin initialMargin;
        StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder initialMarginBuilder = this.doEvaluate(exposure);
        if (initialMarginBuilder == null) {
            initialMargin = null;
        } else {
            initialMargin = initialMarginBuilder.build();
            this.objectValidator.validate(StandardizedScheduleInitialMargin.class, (RosettaModelObject)initialMargin);
        }
        this.conditionValidator.validate(() -> ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)initialMargin).map("getNetInitialMargin", standardizedScheduleInitialMargin -> standardizedScheduleInitialMargin.getNetInitialMargin()).map("getValue", money -> money.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All), "Ensure net initial margin is non-negative");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.tradeInitialMargin(exposure).map("getGrossInitialMargin", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getGrossInitialMargin()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All), "Ensure that only a single currency exists");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.tradeInitialMargin(exposure).map("getMarkToMarketValue", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getMarkToMarketValue()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All), "Ensure that only a single currency exists");
        return initialMargin;
    }

    protected abstract StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder doEvaluate(Exposure var1);

    protected abstract MapperS<? extends ReferenceWithMetaPortfolioState> tradePortfolio(Exposure var1);

    protected abstract MapperC<? extends Position> positions(Exposure var1);

    protected abstract MapperC<? extends StandardizedScheduleTradeInfo> tradeInitialMargin(Exposure var1);

    protected abstract MapperS<BigDecimal> totalGIM(Exposure var1);

    protected abstract MapperS<BigDecimal> netCurrentReplacementCost(Exposure var1);

    protected abstract MapperS<BigDecimal> grossCurrentReplacementCost(Exposure var1);

    protected abstract MapperS<BigDecimal> netToGrossRatio(Exposure var1);

    public static class GetNetInitialMarginFromExposureDefault
    extends GetNetInitialMarginFromExposure {
        @Override
        protected StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder doEvaluate(Exposure exposure) {
            StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder initialMargin = StandardizedScheduleInitialMargin.builder();
            return this.assignOutput(initialMargin, exposure);
        }

        protected StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder assignOutput(StandardizedScheduleInitialMargin.StandardizedScheduleInitialMarginBuilder initialMargin, Exposure exposure) {
            initialMargin.addTradeInfo(this.tradeInitialMargin(exposure).getMulti());
            initialMargin.getOrCreateNetInitialMargin().setValue((BigDecimal)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)new BigDecimal("0.4")), this.totalGIM(exposure)), (Mapper)MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)new BigDecimal("0.6")), this.totalGIM(exposure)), this.netToGrossRatio(exposure))).get());
            initialMargin.getOrCreateNetInitialMargin().getOrCreateUnit().setCurrency((FieldWithMetaString)ExpressionOperators.distinct((Mapper)this.tradeInitialMargin(exposure).map("getMarkToMarketValue", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getMarkToMarketValue()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            return Optional.ofNullable(initialMargin).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaPortfolioState> tradePortfolio(Exposure exposure) {
            return MapperS.of((Object)exposure).map("getTradePortfolio", _exposure -> _exposure.getTradePortfolio());
        }

        @Override
        protected MapperC<? extends Position> positions(Exposure exposure) {
            return this.tradePortfolio(exposure).map("Type coercion", referenceWithMetaPortfolioState -> referenceWithMetaPortfolioState == null ? null : referenceWithMetaPortfolioState.getValue()).mapC("getPositions", portfolioState -> portfolioState.getPositions());
        }

        @Override
        protected MapperC<? extends StandardizedScheduleTradeInfo> tradeInitialMargin(Exposure exposure) {
            return this.positions(exposure).mapItem(item -> {
                MapperC thenArg0 = item.map("getTradeReference", position -> position.getTradeReference()).map("Type coercion", referenceWithMetaTradeState3 -> referenceWithMetaTradeState3 == null ? null : referenceWithMetaTradeState3.getValue()).mapC("getValuationHistory", tradeState -> tradeState.getValuationHistory()).filterItemNullSafe(_item -> ExpressionOperators.areEqual((Mapper)_item.map("getMethod", valuation -> valuation.getMethod()), (Mapper)MapperS.of((Object)((Object)ValuationTypeEnum.MARK_TO_MARKET)), (CardinalityOperator)CardinalityOperator.All).get());
                MapperS thenArg1 = MapperS.of((Object)((Valuation)thenArg0.get()));
                return MapperS.of((Object)StandardizedScheduleTradeInfo.builder().setAssetClass((StandardizedScheduleAssetClassEnum)((Object)((Object)MapperS.of((Object)this.buildStandardizedSchedule.evaluate((Trade)item.map("getTradeReference", position -> position.getTradeReference()).map("Type coercion", referenceWithMetaTradeState0 -> referenceWithMetaTradeState0 == null ? null : referenceWithMetaTradeState0.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).get())).map("getAssetClass", standardizedSchedule -> standardizedSchedule.getAssetClass()).get()))).setProductClass((StandardizedScheduleProductClassEnum)((Object)((Object)MapperS.of((Object)this.buildStandardizedSchedule.evaluate((Trade)item.map("getTradeReference", position -> position.getTradeReference()).map("Type coercion", referenceWithMetaTradeState1 -> referenceWithMetaTradeState1 == null ? null : referenceWithMetaTradeState1.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).get())).map("getProductClass", standardizedSchedule -> standardizedSchedule.getProductClass()).get()))).setGrossInitialMargin(this.getGrossInitialMarginFromStandardizedSchedule.evaluate(this.buildStandardizedSchedule.evaluate((Trade)item.map("getTradeReference", position -> position.getTradeReference()).map("Type coercion", referenceWithMetaTradeState2 -> referenceWithMetaTradeState2 == null ? null : referenceWithMetaTradeState2.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).get()))).setMarkToMarketValue((Money)thenArg1.map("getAmount", valuation -> valuation.getAmount()).get()).build());
            });
        }

        @Override
        protected MapperS<BigDecimal> totalGIM(Exposure exposure) {
            return this.tradeInitialMargin(exposure).map("getGrossInitialMargin", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getGrossInitialMargin()).map("getValue", money -> money.getValue()).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> netCurrentReplacementCost(Exposure exposure) {
            return this.tradeInitialMargin(exposure).map("getMarkToMarketValue", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getMarkToMarketValue()).map("getValue", money -> money.getValue()).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> grossCurrentReplacementCost(Exposure exposure) {
            MapperC thenArg = this.tradeInitialMargin(exposure).map("getMarkToMarketValue", standardizedScheduleTradeInfo -> standardizedScheduleTradeInfo.getMarkToMarketValue()).filterItemNullSafe(item -> ExpressionOperators.greaterThan((Mapper)item.map("getValue", money -> money.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg.map("getValue", money -> money.getValue()).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> netToGrossRatio(Exposure exposure) {
            return MapperMaths.divide(this.netCurrentReplacementCost(exposure), this.grossCurrentReplacementCost(exposure));
        }
    }
}

