/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.functions;

import cdm.legaldocumentation.csa.PostedCreditSupportItem;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PostedCreditSupportItemAmountDefault.class)
public abstract class PostedCreditSupportItemAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public Money evaluate(PostedCreditSupportItem postedItem, String baseCurrency) {
        Money result;
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)postedItem).map("getCashOrSecurityValue", postedCreditSupportItem -> postedCreditSupportItem.getCashOrSecurityValue()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)postedItem).map("getDisputedCashOrSecurityValue", postedCreditSupportItem -> postedCreditSupportItem.getDisputedCashOrSecurityValue()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All)), "");
        Money.MoneyBuilder resultBuilder = this.doEvaluate(postedItem, baseCurrency);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract Money.MoneyBuilder doEvaluate(PostedCreditSupportItem var1, String var2);

    protected abstract MapperS<BigDecimal> cashOrSecurityValue(PostedCreditSupportItem var1, String var2);

    protected abstract MapperS<BigDecimal> haircutPercentage(PostedCreditSupportItem var1, String var2);

    protected abstract MapperS<BigDecimal> fxHaircutPercentage(PostedCreditSupportItem var1, String var2);

    protected abstract MapperS<BigDecimal> additionalHaircutPercentage(PostedCreditSupportItem var1, String var2);

    protected abstract MapperS<BigDecimal> postedCreditSupportAmount(PostedCreditSupportItem var1, String var2);

    public static class PostedCreditSupportItemAmountDefault
    extends PostedCreditSupportItemAmount {
        @Override
        protected Money.MoneyBuilder doEvaluate(PostedCreditSupportItem postedItem, String baseCurrency) {
            Money.MoneyBuilder result = Money.builder();
            return this.assignOutput(result, postedItem, baseCurrency);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder result, PostedCreditSupportItem postedItem, String baseCurrency) {
            result.setValue((BigDecimal)MapperMaths.subtract(this.postedCreditSupportAmount(postedItem, baseCurrency), (Mapper)MapperS.of((Object)postedItem).map("getDisputedCashOrSecurityValue", postedCreditSupportItem -> postedCreditSupportItem.getDisputedCashOrSecurityValue()).map("getValue", money -> money.getValue())).get());
            result.getOrCreateUnit().setCurrency(baseCurrency == null ? FieldWithMetaString.builder().build() : FieldWithMetaString.builder().setValue(baseCurrency).build());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> cashOrSecurityValue(PostedCreditSupportItem postedItem, String baseCurrency) {
            return MapperS.of((Object)postedItem).map("getCashOrSecurityValue", postedCreditSupportItem -> postedCreditSupportItem.getCashOrSecurityValue()).map("getValue", money -> money.getValue());
        }

        @Override
        protected MapperS<BigDecimal> haircutPercentage(PostedCreditSupportItem postedItem, String baseCurrency) {
            return MapperS.of((Object)postedItem).map("getHaircutPercentage", postedCreditSupportItem -> postedCreditSupportItem.getHaircutPercentage());
        }

        @Override
        protected MapperS<BigDecimal> fxHaircutPercentage(PostedCreditSupportItem postedItem, String baseCurrency) {
            return MapperS.of((Object)postedItem).map("getFxHaircutPercentage", postedCreditSupportItem -> postedCreditSupportItem.getFxHaircutPercentage());
        }

        @Override
        protected MapperS<BigDecimal> additionalHaircutPercentage(PostedCreditSupportItem postedItem, String baseCurrency) {
            return MapperS.of((Object)postedItem).map("getFxHaircutPercentage", postedCreditSupportItem -> postedCreditSupportItem.getFxHaircutPercentage());
        }

        @Override
        protected MapperS<BigDecimal> postedCreditSupportAmount(PostedCreditSupportItem postedItem, String baseCurrency) {
            return MapperMaths.multiply(this.cashOrSecurityValue(postedItem, baseCurrency), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)new BigDecimal("1.00")), (Mapper)MapperMaths.add((Mapper)MapperMaths.add(this.haircutPercentage(postedItem, baseCurrency), this.fxHaircutPercentage(postedItem, baseCurrency)), this.additionalHaircutPercentage(postedItem, baseCurrency))));
        }
    }
}

