/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ValueCashEnum")
public enum ValueCashEnum {
    CASH_AMOUNT("CashAmount", "Cash - Amount Thereof"),
    CASH_PERCENTAGE("CashPercentage", "Cash - Amount Thereof multiplied by Valuation Percentage"),
    CASH_PERCENTAGE_LESS_HAIRCUT("CashPercentageLessHaircut", "Cash - Amount Thereof multiplied by (Valuation Percentage - FX Haircut)"),
    OTHER("Other", null);

    private static Map<String, ValueCashEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ValueCashEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ValueCashEnum fromDisplayName(String name) {
        ValueCashEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ValueCashEnum> map = new ConcurrentHashMap<String, ValueCashEnum>();
        for (ValueCashEnum instance : ValueCashEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

