/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.DirectionRatingSet;
import cdm.legaldocumentation.csa.meta.DirectionRatingMultiplierMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DirectionRatingMultiplier", builder=DirectionRatingMultiplierBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="DirectionRatingMultiplier", model="cdm", builder=DirectionRatingMultiplierBuilderImpl.class, version="7.0.0-dev.50")
public interface DirectionRatingMultiplier
extends RosettaModelObject {
    public static final DirectionRatingMultiplierMeta metaData = new DirectionRatingMultiplierMeta();

    public List<? extends DirectionRatingSet> getVariableSet();

    public BigDecimal getExposureMultiplier();

    public DirectionRatingMultiplier build();

    public DirectionRatingMultiplierBuilder toBuilder();

    public static DirectionRatingMultiplierBuilder builder() {
        return new DirectionRatingMultiplierBuilderImpl();
    }

    default public RosettaMetaData<? extends DirectionRatingMultiplier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DirectionRatingMultiplier> getType() {
        return DirectionRatingMultiplier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("variableSet"), processor, DirectionRatingSet.class, this.getVariableSet(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exposureMultiplier"), BigDecimal.class, (Object)this.getExposureMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DirectionRatingMultiplierBuilderImpl
    implements DirectionRatingMultiplierBuilder {
        protected List<DirectionRatingSet.DirectionRatingSetBuilder> variableSet = new ArrayList<DirectionRatingSet.DirectionRatingSetBuilder>();
        protected BigDecimal exposureMultiplier;

        @Override
        @RosettaAttribute(value="variableSet", isRequired=true)
        @RuneAttribute(value="variableSet", isRequired=true)
        public List<? extends DirectionRatingSet.DirectionRatingSetBuilder> getVariableSet() {
            return this.variableSet;
        }

        @Override
        public DirectionRatingSet.DirectionRatingSetBuilder getOrCreateVariableSet(int index) {
            if (this.variableSet == null) {
                this.variableSet = new ArrayList<DirectionRatingSet.DirectionRatingSetBuilder>();
            }
            return (DirectionRatingSet.DirectionRatingSetBuilder)this.getIndex(this.variableSet, index, () -> {
                DirectionRatingSet.DirectionRatingSetBuilder newVariableSet = DirectionRatingSet.builder();
                return newVariableSet;
            });
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public BigDecimal getExposureMultiplier() {
            return this.exposureMultiplier;
        }

        @Override
        @RosettaAttribute(value="variableSet", isRequired=true)
        @RuneAttribute(value="variableSet", isRequired=true)
        public DirectionRatingMultiplierBuilder addVariableSet(DirectionRatingSet _variableSet) {
            if (_variableSet != null) {
                this.variableSet.add(_variableSet.toBuilder());
            }
            return this;
        }

        @Override
        public DirectionRatingMultiplierBuilder addVariableSet(DirectionRatingSet _variableSet, int idx) {
            this.getIndex(this.variableSet, idx, () -> _variableSet.toBuilder());
            return this;
        }

        @Override
        public DirectionRatingMultiplierBuilder addVariableSet(List<? extends DirectionRatingSet> variableSets) {
            if (variableSets != null) {
                for (DirectionRatingSet directionRatingSet : variableSets) {
                    this.variableSet.add(directionRatingSet.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="variableSet")
        public DirectionRatingMultiplierBuilder setVariableSet(List<? extends DirectionRatingSet> variableSets) {
            this.variableSet = variableSets == null ? new ArrayList<DirectionRatingSet.DirectionRatingSetBuilder>() : (List)variableSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public DirectionRatingMultiplierBuilder setExposureMultiplier(BigDecimal _exposureMultiplier) {
            this.exposureMultiplier = _exposureMultiplier == null ? null : _exposureMultiplier;
            return this;
        }

        @Override
        public DirectionRatingMultiplier build() {
            return new DirectionRatingMultiplierImpl(this);
        }

        @Override
        public DirectionRatingMultiplierBuilder toBuilder() {
            return this;
        }

        @Override
        public DirectionRatingMultiplierBuilder prune() {
            this.variableSet = this.variableSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getVariableSet() != null && this.getVariableSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExposureMultiplier() != null;
        }

        public DirectionRatingMultiplierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DirectionRatingMultiplierBuilder o = (DirectionRatingMultiplierBuilder)other;
            merger.mergeRosetta(this.getVariableSet(), o.getVariableSet(), this::getOrCreateVariableSet);
            merger.mergeBasic((Object)this.getExposureMultiplier(), (Object)o.getExposureMultiplier(), this::setExposureMultiplier, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DirectionRatingMultiplier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.variableSet, _that.getVariableSet())) {
                return false;
            }
            return Objects.equals(this.exposureMultiplier, _that.getExposureMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            _result = 31 * _result + (this.exposureMultiplier != null ? this.exposureMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DirectionRatingMultiplierBuilder {variableSet=" + this.variableSet + ", exposureMultiplier=" + this.exposureMultiplier + '}';
        }
    }

    public static interface DirectionRatingMultiplierBuilder
    extends DirectionRatingMultiplier,
    RosettaModelObjectBuilder {
        public DirectionRatingSet.DirectionRatingSetBuilder getOrCreateVariableSet(int var1);

        public List<? extends DirectionRatingSet.DirectionRatingSetBuilder> getVariableSet();

        public DirectionRatingMultiplierBuilder addVariableSet(DirectionRatingSet var1);

        public DirectionRatingMultiplierBuilder addVariableSet(DirectionRatingSet var1, int var2);

        public DirectionRatingMultiplierBuilder addVariableSet(List<? extends DirectionRatingSet> var1);

        public DirectionRatingMultiplierBuilder setVariableSet(List<? extends DirectionRatingSet> var1);

        public DirectionRatingMultiplierBuilder setExposureMultiplier(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("variableSet"), processor, DirectionRatingSet.DirectionRatingSetBuilder.class, this.getVariableSet(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exposureMultiplier"), BigDecimal.class, (Object)this.getExposureMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DirectionRatingMultiplierBuilder prune();
    }

    public static class DirectionRatingMultiplierImpl
    implements DirectionRatingMultiplier {
        private final List<? extends DirectionRatingSet> variableSet;
        private final BigDecimal exposureMultiplier;

        protected DirectionRatingMultiplierImpl(DirectionRatingMultiplierBuilder builder) {
            this.variableSet = Optional.ofNullable(builder.getVariableSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exposureMultiplier = builder.getExposureMultiplier();
        }

        @Override
        @RosettaAttribute(value="variableSet", isRequired=true)
        @RuneAttribute(value="variableSet", isRequired=true)
        public List<? extends DirectionRatingSet> getVariableSet() {
            return this.variableSet;
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public BigDecimal getExposureMultiplier() {
            return this.exposureMultiplier;
        }

        @Override
        public DirectionRatingMultiplier build() {
            return this;
        }

        @Override
        public DirectionRatingMultiplierBuilder toBuilder() {
            DirectionRatingMultiplierBuilder builder = DirectionRatingMultiplier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DirectionRatingMultiplierBuilder builder) {
            Optional.ofNullable(this.getVariableSet()).ifPresent(builder::setVariableSet);
            Optional.ofNullable(this.getExposureMultiplier()).ifPresent(builder::setExposureMultiplier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DirectionRatingMultiplier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.variableSet, _that.getVariableSet())) {
                return false;
            }
            return Objects.equals(this.exposureMultiplier, _that.getExposureMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            _result = 31 * _result + (this.exposureMultiplier != null ? this.exposureMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DirectionRatingMultiplier {variableSet=" + this.variableSet + ", exposureMultiplier=" + this.exposureMultiplier + '}';
        }
    }
}

