/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.workflowstep.functions;

import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.event.common.ContractFormationInstruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.Transfer;
import cdm.event.common.TransferExpression;
import cdm.event.common.TransferInstruction;
import cdm.event.common.TransferState;
import cdm.ingest.fpml.confirmation.common.functions.MapFeeTypeEnumWithScheme;
import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustableOrAdjustedDateToAdjustableOrAdjustedOrRelativeDate;
import cdm.ingest.fpml.confirmation.legal.functions.MapLegalAgreementList;
import cdm.ingest.fpml.confirmation.other.functions.MapFeeTypeEnum;
import cdm.ingest.fpml.confirmation.party.functions.MapCounterpartyList;
import cdm.ingest.fpml.confirmation.party.functions.MapPartyReference;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapNonNegativeMoneyToQuantity;
import cdm.ingest.fpml.confirmation.workflowstep.functions.MapPriceQuantity;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.observable.asset.FeeTypeEnum;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.metafields.FieldWithMetaFeeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import fpml.confirmation.AdjustableOrAdjustedDate;
import fpml.confirmation.Documentation;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.Payment;
import fpml.confirmation.Trade;
import fpml.confirmation.TradeNotionalChange;
import fpml.confirmation.TradeNotionalChangeModelSequence0;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapTerminationToPrimitiveInstructionDefault.class)
public abstract class MapTerminationToPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustableOrAdjustedDateToAdjustableOrAdjustedOrRelativeDate mapAdjustableOrAdjustedDateToAdjustableOrAdjustedOrRelativeDate;
    @Inject
    protected MapCounterpartyList mapCounterpartyList;
    @Inject
    protected MapFeeTypeEnum mapFeeTypeEnum;
    @Inject
    protected MapFeeTypeEnumWithScheme mapFeeTypeEnumWithScheme;
    @Inject
    protected MapLegalAgreementList mapLegalAgreementList;
    @Inject
    protected MapNonNegativeMoneyToQuantity mapNonNegativeMoneyToQuantity;
    @Inject
    protected MapPartyReference mapPartyReference;
    @Inject
    protected MapPriceQuantity mapPriceQuantity;

    public PrimitiveInstruction evaluate(Trade fpmlTrade, TradeNotionalChange termination) {
        PrimitiveInstruction primitiveInstruction;
        PrimitiveInstruction.PrimitiveInstructionBuilder primitiveInstructionBuilder = this.doEvaluate(fpmlTrade, termination);
        if (primitiveInstructionBuilder == null) {
            primitiveInstruction = null;
        } else {
            primitiveInstruction = primitiveInstructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)primitiveInstruction);
        }
        return primitiveInstruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(Trade var1, TradeNotionalChange var2);

    protected abstract MapperC<? extends Counterparty> counterpartyList(Trade var1, TradeNotionalChange var2);

    protected abstract MapperS<? extends Payment> payment(Trade var1, TradeNotionalChange var2);

    protected abstract MapperS<? extends NonNegativeQuantitySchedule> terminationPayment(Trade var1, TradeNotionalChange var2);

    public static class MapTerminationToPrimitiveInstructionDefault
    extends MapTerminationToPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(Trade fpmlTrade, TradeNotionalChange termination) {
            PrimitiveInstruction.PrimitiveInstructionBuilder primitiveInstruction = PrimitiveInstruction.builder();
            return this.assignOutput(primitiveInstruction, fpmlTrade, termination);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder primitiveInstruction, Trade fpmlTrade, TradeNotionalChange termination) {
            TransferState transferState = TransferState.builder().setTransfer(Transfer.builder().setQuantity(NonNegativeQuantity.builder().setValue((BigDecimal)this.terminationPayment(fpmlTrade, termination).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get()).setUnit((UnitType)this.terminationPayment(fpmlTrade, termination).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).get()).build()).setAsset(Asset.builder().setCash(Cash.builder().setIdentifier(this.terminationPayment(fpmlTrade, termination).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).mapSingleToItem(item -> {
                AssetIdTypeEnum ifThenElseResult = null;
                if (ExpressionOperators.exists((Mapper)item).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = AssetIdTypeEnum.CURRENCY_CODE;
                }
                return MapperS.of((Object)AssetIdentifier.builder().setIdentifier((FieldWithMetaString)item.get()).setIdentifierType(ifThenElseResult).build());
            }).getMulti()).build()).build()).setSettlementDate(this.mapAdjustableOrAdjustedDateToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrAdjustedDate)this.payment(fpmlTrade, termination).map("getPaymentDate", _payment -> _payment.getPaymentDate()).get())).setPayerReceiver((PartyReferencePayerReceiver)this.payment(fpmlTrade, termination).map("getPayerReceiverModel", _payment -> _payment.getPayerReceiverModel()).mapSingleToItem(item -> MapperS.of((Object)PartyReferencePayerReceiver.builder().setPayerPartyReference(this.mapPartyReference.evaluate((String)item.map("getPayerModel", payerReceiverModel -> payerReceiverModel.getPayerModel()).map("getPayerPartyReference", payerModel -> payerModel.getPayerPartyReference()).map("getHref", partyReference -> partyReference.getHref()).get())).setReceiverPartyReference(this.mapPartyReference.evaluate((String)item.map("getReceiverModel", payerReceiverModel -> payerReceiverModel.getReceiverModel()).map("getReceiverPartyReference", receiverModel -> receiverModel.getReceiverPartyReference()).map("getHref", partyReference -> partyReference.getHref()).get())).build())).get()).setTransferExpression((TransferExpression)this.payment(fpmlTrade, termination).mapSingleToItem(item -> {
                FieldWithMetaFeeTypeEnum fieldWithMetaFeeTypeEnum;
                FeeTypeEnum ifThenElseResult = ExpressionOperators.exists((Mapper)item.map("getId", _payment -> _payment.getId())).getOrDefault(Boolean.valueOf(false)) != false ? this.mapFeeTypeEnum.evaluate((String)item.map("getId", _payment -> _payment.getId()).get()) : ((fieldWithMetaFeeTypeEnum = this.mapFeeTypeEnumWithScheme.evaluate((String)item.map("getPaymentType", _payment -> _payment.getPaymentType()).map("getValue", paymentType -> paymentType.getValue()).map("to-string", Object::toString).get(), (String)item.map("getPaymentType", _payment -> _payment.getPaymentType()).map("getPaymentTypeScheme", paymentType -> paymentType.getPaymentTypeScheme()).get())) == null ? null : fieldWithMetaFeeTypeEnum.getValue());
                return MapperS.of((Object)TransferExpression.builder().setPriceTransfer(ifThenElseResult).build());
            }).get()).build()).build();
            primitiveInstruction = (PrimitiveInstruction.PrimitiveInstructionBuilder)this.toBuilder(PrimitiveInstruction.builder().setContractFormation(ContractFormationInstruction.builder().setLegalAgreement(new ArrayList<LegalAgreement>(this.mapLegalAgreementList.evaluate((Documentation)MapperS.of((Object)fpmlTrade).map("getDocumentation", trade -> trade.getDocumentation()).get(), this.counterpartyList(fpmlTrade, termination).getMulti()))).build()).setQuantityChange((QuantityChangeInstruction)MapperS.of((Object)termination).map("getTradeNotionalChangeModel", tradeNotionalChange -> tradeNotionalChange.getTradeNotionalChangeModel()).map("getTradeNotionalChangeModelSequence0", tradeNotionalChangeModel -> tradeNotionalChangeModel.getTradeNotionalChangeModelSequence0()).mapSingleToItem(item -> {
                QuantityChangeDirectionEnum ifThenElseResult = null;
                if (ExpressionOperators.exists((Mapper)item).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = QuantityChangeDirectionEnum.REPLACE;
                }
                return MapperS.of((Object)QuantityChangeInstruction.builder().setChange(new ArrayList<PriceQuantity>(this.mapPriceQuantity.evaluate((TradeNotionalChangeModelSequence0)item.get()))).setDirection(ifThenElseResult).build());
            }).get()).setTransfer(TransferInstruction.builder().setTransferState(transferState == null ? Collections.emptyList() : Collections.singletonList(transferState)).build()).build());
            return Optional.ofNullable(primitiveInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends Counterparty> counterpartyList(Trade fpmlTrade, TradeNotionalChange termination) {
            return MapperC.of(this.mapCounterpartyList.evaluate(fpmlTrade));
        }

        @Override
        protected MapperS<? extends Payment> payment(Trade fpmlTrade, TradeNotionalChange termination) {
            return MapperS.of((Object)((Payment)ExpressionOperators.distinct((Mapper)MapperS.of((Object)termination).map("getTradeAlterationPaymentModel", tradeNotionalChange -> tradeNotionalChange.getTradeAlterationPaymentModel()).mapC("getPayment", tradeAlterationPaymentModel -> tradeAlterationPaymentModel.getPayment())).get()));
        }

        @Override
        protected MapperS<? extends NonNegativeQuantitySchedule> terminationPayment(Trade fpmlTrade, TradeNotionalChange termination) {
            return MapperS.of((Object)this.mapNonNegativeMoneyToQuantity.evaluate((NonNegativeMoney)MapperS.of((Object)((Payment)ExpressionOperators.distinct((Mapper)MapperS.of((Object)termination).map("getTradeAlterationPaymentModel", tradeNotionalChange -> tradeNotionalChange.getTradeAlterationPaymentModel()).mapC("getPayment", tradeAlterationPaymentModel -> tradeAlterationPaymentModel.getPayment())).get())).map("getPaymentAmount", _payment -> _payment.getPaymentAmount()).get()));
        }
    }
}

