/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.Currency;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCurrencyToAssetCashDefault.class)
public abstract class MapCurrencyToAssetCash
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;

    public Asset evaluate(Currency fpmlCurrency) {
        Asset asset;
        Asset.AssetBuilder assetBuilder = this.doEvaluate(fpmlCurrency);
        if (assetBuilder == null) {
            asset = null;
        } else {
            asset = assetBuilder.build();
            this.objectValidator.validate(Asset.class, (RosettaModelObject)asset);
        }
        return asset;
    }

    protected abstract Asset.AssetBuilder doEvaluate(Currency var1);

    public static class MapCurrencyToAssetCashDefault
    extends MapCurrencyToAssetCash {
        @Override
        protected Asset.AssetBuilder doEvaluate(Currency fpmlCurrency) {
            Asset.AssetBuilder asset = Asset.builder();
            return this.assignOutput(asset, fpmlCurrency);
        }

        protected Asset.AssetBuilder assignOutput(Asset.AssetBuilder asset, Currency fpmlCurrency) {
            AssetIdentifier assetIdentifier = AssetIdentifier.builder().setIdentifier(this.mapCurrency.evaluate(fpmlCurrency)).setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE).build();
            asset = (Asset.AssetBuilder)this.toBuilder(Asset.builder().setCash(Cash.builder().setIdentifier(assetIdentifier == null ? Collections.emptyList() : Collections.singletonList(assetIdentifier)).build()).build());
            return Optional.ofNullable(asset).map(o -> o.prune()).orElse(null);
        }
    }
}

