/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.event.common.TransferState;
import cdm.ingest.fpml.confirmation.payment.functions.MapSimplePaymentToTransferState;
import cdm.observable.asset.FeeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Premium;
import fpml.confirmation.SimplePayment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapPremiumListToTransferStateListDefault.class)
public abstract class MapPremiumListToTransferStateList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapSimplePaymentToTransferState mapSimplePaymentToTransferState;

    public List<? extends TransferState> evaluate(List<? extends Premium> fpmlPremiumList, FeeTypeEnum cdmFeeType) {
        List transferStateList;
        List<TransferState.TransferStateBuilder> transferStateListBuilder = this.doEvaluate(fpmlPremiumList, cdmFeeType);
        if (transferStateListBuilder == null) {
            transferStateList = null;
        } else {
            transferStateList = transferStateListBuilder.stream().map(TransferState::build).collect(Collectors.toList());
            this.objectValidator.validate(TransferState.class, transferStateList);
        }
        return transferStateList;
    }

    protected abstract List<TransferState.TransferStateBuilder> doEvaluate(List<? extends Premium> var1, FeeTypeEnum var2);

    public static class MapPremiumListToTransferStateListDefault
    extends MapPremiumListToTransferStateList {
        @Override
        protected List<TransferState.TransferStateBuilder> doEvaluate(List<? extends Premium> fpmlPremiumList, FeeTypeEnum cdmFeeType) {
            if (fpmlPremiumList == null) {
                fpmlPremiumList = Collections.emptyList();
            }
            ArrayList<TransferState.TransferStateBuilder> transferStateList = new ArrayList<TransferState.TransferStateBuilder>();
            return this.assignOutput(transferStateList, fpmlPremiumList, cdmFeeType);
        }

        protected List<TransferState.TransferStateBuilder> assignOutput(List<TransferState.TransferStateBuilder> transferStateList, List<? extends Premium> fpmlPremiumList, FeeTypeEnum cdmFeeType) {
            transferStateList.addAll(this.toBuilder(MapperC.of(fpmlPremiumList).mapItem(item -> MapperS.of((Object)this.mapSimplePaymentToTransferState.evaluate((SimplePayment)item.get(), cdmFeeType))).getMulti()));
            return Optional.ofNullable(transferStateList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

